/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.samples;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004BotController;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveSkid;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.Initialize;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.ConfigurationMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.GeometryMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.MissionPackageMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.ResponseMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.SensorMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.StateMessage;
import cz.cuni.amis.pogamut.usar2004.utils.USAR2004BotRunner;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;

@AgentScoped
public class USAR2004TestBot
extends USAR2004BotController {
    IWorldEventListener<NfoMessage> nfoList = new IWorldEventListener<NfoMessage>(){

        public void notify(NfoMessage t) {
            System.out.println("INFO INFO FOR STARTERS" + t.toString());
            if (!USAR2004TestBot.this.first) {
                USAR2004TestBot.this.getAct().act((CommandMessage)new Initialize("USARBot.P3AT", "Item", new Location(0.6903, 4.7984, 7.832), null));
                USAR2004TestBot.this.first = true;
            }
        }
    };
    IWorldEventListener<GeometryMessage> geoList = new IWorldEventListener<GeometryMessage>(){

        public void notify(GeometryMessage t) {
            System.out.println("GEOMETRY GEOMETRY" + t.toString());
        }
    };
    IWorldEventListener<MissionPackageMessage> missList = new IWorldEventListener<MissionPackageMessage>(){

        public void notify(MissionPackageMessage t) {
            System.out.println("MISSION PACKAGE MISSION PACKAGE" + t.toString());
        }
    };
    IWorldEventListener<ResponseMessage> respList = new IWorldEventListener<ResponseMessage>(){

        public void notify(ResponseMessage t) {
            System.out.println("RESPONSE MESSAGE RESPONSE MESSAGE" + t.toString());
        }
    };
    IWorldEventListener<SensorMessage> sensorList = new IWorldEventListener<SensorMessage>(){

        public void notify(SensorMessage t) {
            if (t.getLaserRanges().size() > 1) {
                ArrayList<Double> f = new ArrayList<Double>();
                f.addAll(t.getLaserRanges());
                USAR2004TestBot.this.RangesReady(f);
            }
        }
    };
    private int step = 20;
    boolean reversActive = false;
    IWorldEventListener<StateMessage> statList = new IWorldEventListener<StateMessage>(){

        public void notify(StateMessage t) {
            USAR2004TestBot.this.logic();
        }
    };
    IWorldEventListener<ConfigurationMessage> confList = new IWorldEventListener<ConfigurationMessage>(){

        public void notify(ConfigurationMessage t) {
            System.out.println("CONFIGURATION CONFIGURATION" + t.toString());
        }
    };
    boolean first = false;
    int left = 0;
    int right = 0;

    @Override
    public void initializeController(USAR2004Bot bot) {
        super.initializeController(bot);
    }

    @Override
    public void prepareBot(USAR2004Bot bot) {
        super.prepareBot(bot);
        this.getWorldView().addEventListener(ConfigurationMessage.class, this.confList);
        this.getWorldView().addEventListener(StateMessage.class, this.statList);
        this.getWorldView().addEventListener(SensorMessage.class, this.sensorList);
        this.getWorldView().addEventListener(ResponseMessage.class, this.respList);
        this.getWorldView().addEventListener(MissionPackageMessage.class, this.missList);
        this.getWorldView().addEventListener(GeometryMessage.class, this.geoList);
        this.getWorldView().addEventListener(NfoMessage.class, this.nfoList);
        Map allVisible = this.getWorldView().getAllVisible();
        System.out.println(allVisible.size());
        System.out.println("TEST");
    }

    private void driveLeft() {
        System.out.println("left");
        this.right = 15;
        this.left = 5;
    }

    private void driveRight() {
        System.out.println("right");
        this.right = 4;
        this.left = 15;
    }

    private void driveStraight() {
        System.out.println("straight");
        this.right = 15;
        this.left = 15;
    }

    private void driveBackwards() {
        System.out.println("back");
        if (this.step > 10) {
            this.right = -3;
            this.left = -3;
        } else {
            this.right = -3;
            this.left = 3;
        }
        --this.step;
        if (this.step == 0) {
            this.step = 20;
            this.reversActive = false;
        }
    }

    public void RangesReady(ArrayList<Double> Ranges) {
        int third = Ranges.size() / 3;
        double mleft = 0.0;
        double mright = 0.0;
        double mstraight = 0.0;
        for (int i = 0; i < Ranges.size(); ++i) {
            if (i < third) {
                mright += Ranges.get(i).doubleValue();
                continue;
            }
            if (i < 2 * third) {
                mstraight += Ranges.get(i).doubleValue();
                continue;
            }
            mleft += Ranges.get(i).doubleValue();
        }
        System.out.println(mleft + " " + mstraight + " " + mright);
        if (this.reversActive || mleft + mstraight < 200.0 || mright + mstraight < 200.0) {
            this.reversActive = true;
            this.driveBackwards();
        } else if (Math.max(mleft, mright) == mleft) {
            if (Math.max(mleft, mstraight) == mleft) {
                this.driveLeft();
            } else {
                this.driveStraight();
            }
        } else if (Math.max(mright, mstraight) == mright) {
            this.driveRight();
        } else {
            this.driveStraight();
        }
    }

    public static void main(String[] args) {
        new USAR2004BotRunner(USAR2004TestBot.class, "PogamutBotBot", "127.0.0.1", 3000).setMain(true).setLogLevel(Level.WARNING).startAgent();
    }

    public void logic() {
        this.getAct().act((CommandMessage)new DriveSkid(this.left, this.right, false, false, false));
    }
}

