/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.factory.guice.remoteagent;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.base.communication.worldview.ILockableWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.usar2004.agent.IUSAR2004BotController;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.params.USAR2004AgentParameters;
import cz.cuni.amis.pogamut.usar2004.communication.translator.USARBotFSM;
import cz.cuni.amis.pogamut.usar2004.communication.worldview.USAR2004SyncLockableWorldView;
import cz.cuni.amis.pogamut.usar2004.factory.guice.remoteagent.USAR2004CommunicationModule;
import cz.cuni.amis.utils.token.IToken;
import java.lang.annotation.Annotation;

public class USAR2004BotModule<PARAMS extends USAR2004AgentParameters>
extends USAR2004CommunicationModule<PARAMS> {
    protected AdaptableProvider<ComponentDependencies> worldViewDependenciesProvider = new AdaptableProvider(null);
    private Class<? extends IUSAR2004BotController> botControllerClass;

    protected USAR2004BotModule() {
    }

    public USAR2004BotModule(Class<? extends IUSAR2004BotController> botControllerClass) {
        this.botControllerClass = botControllerClass;
    }

    @Override
    public void prepareNewAgent(PARAMS agentParameters) {
        super.prepareNewAgent(agentParameters);
        this.worldViewDependenciesProvider.set((Object)new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IToken)agentParameters.getAgentId()));
    }

    @Override
    protected void configureModules() {
        super.configureModules();
        this.addModule(new AbstractModule(){

            public void configure() {
                this.bind(IWorldMessageTranslator.class).to(USARBotFSM.class);
                this.bind(IWorldView.class).to(IVisionWorldView.class);
                this.bind(IVisionWorldView.class).to(ILockableVisionWorldView.class);
                this.bind(ILockableWorldView.class).to(ILockableVisionWorldView.class);
                this.bind(ILockableVisionWorldView.class).to(USAR2004SyncLockableWorldView.class);
                this.bind(ComponentDependencies.class).annotatedWith((Annotation)Names.named((String)"USAR2004SyncLockableWorldViewDependency")).toProvider(USAR2004BotModule.this.worldViewDependenciesProvider);
                this.bind(IAgent.class).to(USAR2004Bot.class);
                if (USAR2004BotModule.this.botControllerClass != null) {
                    this.bind(IUSAR2004BotController.class).to(USAR2004BotModule.this.botControllerClass);
                }
            }
        });
    }
}

