package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * Drive command specified for a ground vehicle with no steering.
 *
 * Corresponding GameBots command is DRIVE.
 *
 */
public class DriveSkid extends CommandMessage
{
    //constructor for the first type
    public DriveSkid(double Left, double Right, boolean Normalized, boolean Light, boolean Flip)
    {
        this.Left = Left;
        this.Right = Right;
        this.Normalized = Normalized;
        this.Light = Light;
        this.Flip = Flip;
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * setters to fill it up!
     */
    public DriveSkid()
    {
    }
    /////// Properties BEGIN
    //first type - Left, Right, Normalized, Light, Flip
    /*
     * spin speed for the left side wheels. If we are using normalized values,
     * the value range is –100 to 100 and corresponds to the robot’s minimum and
     * maximum spin speed. If we use absolute values, the value will be the real
     * spin speed in radians per second.
     */
    protected double Left = 0;

    public double getLeft()
    {
        return Left;
    }

    public DriveSkid setLeft(double Left)
    {
        this.Left = Left;
        return this;
    }
    //Same as Left but for the Right side
    protected double Right = 0;

    public double getRight()
    {
        return Right;
    }

    public DriveSkid setRight(double Right)
    {
        this.Right = Right;
        return this;
    }
    /*
     * Indicates whether we are using normalized values or ´ * not. The default
     * value is ‘False’ which means absolute values are used to control wheel
     * spin speed.
     */
    protected boolean Normalized = false;

    public boolean isNormalized()
    {
        return Normalized;
    }

    public DriveSkid setNormalized(boolean Normalized)
    {
        this.Normalized = Normalized;
        return this;
    }
    //Indicates whether to turn the headlight on or off
    protected boolean Light = false;

    public boolean isLight()
    {
        return Light;
    }

    public DriveSkid setLight(boolean Light)
    {
        this.Light = Light;
        return this;
    }
    //Flip will flip the robot on its wheels if its rolled over
    protected boolean Flip = false;

    public boolean isFlip()
    {
        return Flip;
    }

    public DriveSkid setFlip(boolean Flip)
    {
        this.Flip = Flip;
        return this;
    }

    /*
     * Example: DRIVE {Left 1.0} {Right 1.0} will drive the robot moving forward
     * with spin seed 1 radian per second. DRIVE {Left -1.0} {Right 1.0} will
     * turn the robot to left side. DRIVE {Light true} will turn on the
     * headlight. DRIVE {Flip true} will flip the robot.
     */
    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public DriveSkid(DriveSkid original)
    {
        this.Left = original.Left;
        this.Right = original.Right;
        this.Normalized = original.Normalized;
        this.Flip = original.Flip;
        this.Light = original.Light;
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        return super.toString()
                + "<b>Left</b> : "
                + String.valueOf(Left)
                + " <br/> "
                + "<b>Right</b> : "
                + String.valueOf(Right)
                + " <br/> "
                + "<b>Normalized</b> : "
                + String.valueOf(Normalized)
                + " <br/> "
                + "<b>Flip</b> : "
                + String.valueOf(Flip)
                + " <br/> "
                + "<b>Light</b> : "
                + String.valueOf(Light)
                + " <br/> "
                + "";
    }

    public String toMessage()
    {
        StringBuilder buf = new StringBuilder();
        buf.append("DRIVE");
        buf.append(" {Left ").append(Left).append("}");
        buf.append(" {Right ").append(Right).append("}");
        buf.append(" {Normalized ").append(Normalized).append("}");
        buf.append(" {Light ").append(Light).append("}");
        buf.append(" {Flip ").append(Flip).append("}");

        return buf.toString();
    }
}
