package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * Drive command specified for an aircraft.
 *
 * Corresponding GameBots command is DRIVE.
 *
 */
public class DriveAerial extends CommandMessage
{
    //constructor for the fourth type
    public DriveAerial(double AltitudeVelocity, double LinearVelocity, double LateralVelocity, double RotationalVelocity, boolean Normalized)
    {
        this.AltitudeVelocity = AltitudeVelocity;
        this.LinearVelocity = LinearVelocity;
        this.LateralVelocity = LateralVelocity;
        this.RotationalVelocity = RotationalVelocity;
        this.Normalized = Normalized;
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * setters to fill it up!
     */
    public DriveAerial()
    {
    }
    /////// Properties BEGIN
    //fourth type - AltitudeVelocity, LinearVelocity, LateralVelocity, RotationalVelocity, Normalized 
    /*
     * the altitude velocity (i.e up/down). If we use normalized values, the
     * value range is -100 to 100 and corresponds to the robot’s minimum and
     * maximum altitude velocity, respectively. Otherwise, the value is the
     * absolute altitude velocity, in meters per second.
     */
    protected double AltitudeVelocity = 0;

    public double getAltitudeVelocity()
    {
        return AltitudeVelocity;
    }

    public DriveAerial setAltitudeVelocity(double AltitudeVelocity)
    {
        this.AltitudeVelocity = AltitudeVelocity;
        return this;
    }
    /*
     * the linear velocity (i.e forward/backward). If we use normalized values,
     * the value range is -100 to 100 and corresponds to the robot’s minimum and
     * maximum linear velocity, respectively. Otherwise, the value is the
     * absolute linear velocity, in meters per second.
     */
    protected double LinearVelocity = 0;

    public double getLinearVelocity()
    {
        return LinearVelocity;
    }

    public DriveAerial setLinearVelocity(double LinearVelocity)
    {
        this.LinearVelocity = LinearVelocity;
        return this;
    }
    /*
     * the lateral velocity (i.e left/right). If we use normalized values, the
     * value range is -100 to 100 and corresponds to the robot’s minimum and
     * maximum lateral velocity, respectively. Otherwise, the value is the
     * absolute lateral velocity, in meters per second.
     */
    protected double LateralVelocity = 0;

    public double getLaterarVelocity()
    {
        return LateralVelocity;
    }

    public DriveAerial setLaterarVelocity(double LaterarVelocity)
    {
        this.LateralVelocity = LaterarVelocity;
        return this;
    }
    /*
     * the rotational velocity. If we use normalized values, the value range is
     * -100 to 100 and corresponds to the robot’s minimum and maximum rotational
     * velocity, respectively. Otherwise, the value is the absolute rotational
     * velocity, in radians per second.
     */
    protected double RotationalVelocity = 0;

    public double getRotationalVelocity()
    {
        return RotationalVelocity;
    }

    public DriveAerial setRotationalVelocity(double RotationalVelocity)
    {
        this.RotationalVelocity = RotationalVelocity;
        return this;
    }
    /*
     * Example: DRIVE {AltitudeVelocity 1} will elevate the robot at a rate of 1
     * meters per second. DRIVE {RotationalVelocity 0.1} will rotate the robot
     * at a rate of 0.1 radians per second. DRIVE {LinearVelocity -3} will make
     * the robot go backward at a rate of 3 meters per second.
     */
    /*
     * Indicates whether we are using normalized values or ´ * not. The default
     * value is ‘False’ which means absolute values are used to control wheel
     * spin speed.
     */
    protected boolean Normalized = false;

    public boolean isNormalized()
    {
        return Normalized;
    }

    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public DriveAerial(DriveAerial original)
    {
        this.Normalized = original.Normalized;
        this.AltitudeVelocity = original.AltitudeVelocity;
        this.LinearVelocity = original.LinearVelocity;
        this.LateralVelocity = original.LateralVelocity;
        this.RotationalVelocity = original.RotationalVelocity;
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        return super.toString()
                + "<b>AltitudeVelocity</b> : "
                + String.valueOf(AltitudeVelocity)
                + " <br/> "
                + "<b>LinearVelocity</b> : "
                + String.valueOf(LinearVelocity)
                + " <br/> "
                + "<b>LateralVelocity</b> : "
                + String.valueOf(LateralVelocity)
                + " <br/> "
                + "<b>RotationalVelocity</b> : "
                + String.valueOf(RotationalVelocity)
                + " <br/> "
                + "<b>Normalized</b> : "
                + String.valueOf(Normalized)
                + " <br/> "
                + "";
    }

    public String toMessage()
    {

        StringBuilder buf = new StringBuilder();
        buf.append("DRIVE");
        buf.append(" {Normalized ").append(Normalized).append("}");
        buf.append(" {AltitudeVelocity ").append(AltitudeVelocity).append("}");
        buf.append(" {LinearVelocity ").append(LinearVelocity).append("}");
        buf.append(" {LateralVelocity ").append(LateralVelocity).append("}");
        buf.append(" {RotationalVelocity ").append(RotationalVelocity).append("}");

        return buf.toString();
    }
}
