package cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes;

/**
 * ‘int’, ’float’, ’char’ provide the longitude degree, minute (as a decimal),
 * and cardinal description (i.e. ‘E’ or ‘W’), respectively. There are only two
 * possible values for the ‘char’ parameter: ‘E’ for East and ‘W’ for West.
 *
 * This class is used to store data from GPS sensor.
 *
 * @author vejmanm
 */
public class Longitude extends GeographicCoordinates
{
    public Longitude()
    {
    }

    public Longitude(int degree, double minute, char cardinal)
    {
        super(degree, minute, cardinal);
    }

    /**
     * Converter method for converting the degree, minute to minutes
     * respectively to cardinal character.
     *
     * @param longitude Longitude to convert
     * @return Returns minute representation of input longitude.
     */
    public static double DMCToMinutes(Longitude longitude)
    {
        double returnee = longitude.minute + longitude.degree * 60;
        return (longitude.cardinal == 'W')?-returnee:returnee;
    }

    /**
     * Converter method for converting minutes to degree minutes and to
     * determine cardinal character.
     *
     * @param minutes Minute representation of Longitude
     * @return Returns longitude representation of input minutes.
     */
    public static Longitude MinutesTODMC(double minutes)
    {
        double minute = Math.abs(minutes % 60);
        int degree = Math.abs((int) minutes / 60);
        char cardinal = (minutes < 0)?'W':'E';
        return new Longitude(degree, minute, cardinal);
    }

    /**
     * Converter method for converting the degree, minute to degrees
     * respectively to cardinal character.
     *
     * @param longitude Longitude to convert
     * @return Returns degree representation of input longitude.
     */
    public static double DMCToDegree(Longitude longitude)
    {
        double returnee = longitude.minute / 60d + longitude.degree;
        return (longitude.getCardinal() == 'W')?-returnee:returnee;
    }

    /**
     * Converter method for converting degrees to degree minutes and to
     * determine cardinal character.
     *
     * @param degree Degree representation of Longitude
     * @return Returns longitude representation of input degrees.
     */
    public static Longitude DegreeToDMC(double degree)
    {
        int deg = (int) Math.abs(degree);
        double minute = (Math.abs(degree) - deg) * 60;
        char cardinal = (degree < 0)?'W':'E';
        return new Longitude(deg, minute, cardinal);
    }
}
