package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;

/**
 * Sensor message representative for Human motion detector.
 *
 * @author vejmanm
 */
public class SensorHumanMotionDetector extends SuperSensor
{
    //public static final String type="HumanMotion";
    public static final SensorType type = SensorType.HUMAN_MOTION_DETECTION;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorHumanMotionDetector()
    {
        super(type);
    }

    /**
     * Prob is the probability of it’s human motion.
     *
     * @return Returns the probability of Human motion detector.
     */
    public double getProbability()
    {
        return lastMessage.getProb();
    }
}
