package cz.cuni.amis.pogamut.usar2004.agent.module.response;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.ResponseType;

/**
 * After a SET {Type ResponseCamera} command, follwing response message will be
 * issued
 *
 * @author vejmanm
 */
public class ResponseCamera extends SuperResponse
{
    public static final ResponseType type = ResponseType.CAMERA;

    /**
     * Ctor. Response type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public ResponseCamera()
    {
        super(type);
    }

    /**
     * Name of the camera that will be described by the next two parameters: FOV
     * and Status.
     *
     * @param index
     * @return Returns name of camera at given index.
     */
    public String getNameAt(int index)
    {
        if(index < getSize())
        {
            return lastMessage.getNames().get(index);
        }
        return null;
    }

    /**
     * Each value is the current field of view of the camera being described, in
     * radians. The current field of view is the field of view after a SET {Type
     * Camera} has been issued.
     *
     * @param index
     * @return Returns field of view of camera at given index.
     */
    public String getFOVAt(int index)
    {
        //TODO - is it necessary to get it as a string?!
        if(index < getSize())
        {
            return lastMessage.getFOVs().get(index);
        }
        return null;
    }

    /**
     * Status of the viewport configuration after the SET command has been
     * issued. The status will be “OK” when the viewport configuration was
     * successfully changed. Otherwise, the status will be “Failed”.
     *
     * List of statuses is also used when setting cameras. Each value is then
     * the status for the camera’s field of view after the SET command has been
     * issued. The status will be “OK” when the camera’s field of view was
     * successfully changed. Otherwise, the status will be “Failed”.
     *
     * When responsing to SET command for sensor or effecter, single value
     * describing the status of the transaction will be present in the list.
     *
     * @param index
     * @return Returns status result at given index.
     */
    public String getStatusAt(int index)
    {
        if(index < getSize())
        {
            return lastMessage.getStatuses().get(index);
        }
        return null;
    }

    /**
     * Returns size of names list - size of FOVs and Statuses should be the
     * same.
     *
     * @return Returns size of names list.
     */
    public int getSize()
    {
        return lastMessage.getNames().size();
    }
}
