package cz.cuni.amis.pogamut.usar2004.agent.module.nfo;

import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.StartPose;
import java.util.List;

/**
 * Nfo message representative for Start Poses.
 *
 * @author vejmanm
 */
public class NfoStartPoses extends SuperNfo
{
    /**
     * Ctor. Nfo type describes particular subject about which we want to know
     * about. It is used to distinguish incoming message from the server.
     *
     * @param bot USAR2004Bot variable for filling base class.
     */
    public NfoStartPoses(USAR2004Bot bot)
    {
        super(bot, "StartPoses");
    }

    /**
     * StartPoseCount is the number of starting positions available. For every
     * starting position you'll be able to receive it's tag, location and
     * orientation:
     *
     * @return Returns number of availible start positions.
     */
    public int getStartPosesSize()
    {
        return lastMessage.getStartPoseCount();
    }

    /**
     * GETSTARTPOSES will cause receipt of the NFO message with potencial
     * Locations for spawning a robot.
     *
     * @return Returns list of possible starting positions.
     */
    public List<StartPose> getStartPoses()
    {
        return lastMessage.getStartPoses();
    }
}
