/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.usar2004.communication.translator;

import com.google.inject.Inject;
import cz.cuni.amis.fsm.FSM;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.exception.TranslatorException;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.usar2004.communication.translator.IWorldEventQueue;
import cz.cuni.amis.pogamut.usar2004.communication.translator.USARTranslatorContext;
import cz.cuni.amis.pogamut.usar2004.communication.translator.state.DefaultState;
import java.util.logging.Logger;

public class USARBotFSM
implements IWorldMessageTranslator {
    private IWorldEventQueue eventQueue = new IWorldEventQueue.Queue();
    private USARTranslatorContext context = null;
    private FSM<InfoMessage, USARTranslatorContext> fsm = null;
    private Logger log;

    @Inject
    public USARBotFSM(IAgentLogger logger) {
        this.log = logger.getCategory(this.getClass().getSimpleName());
        this.context = new USARTranslatorContext(this.eventQueue, this.log);
        this.fsm = new FSM((Object)this.context, DefaultState.class, this.log);
    }

    public IWorldChangeEvent[] processMessage(InfoMessage message) throws TranslatorException {
        this.fsm.push((Object)this.context, (Object)message);
        return this.eventQueue.popEvents();
    }

    public void reset() {
        this.context.reset();
        this.fsm.restart((Object)this.context);
    }

    public String toString() {
        return "USARBotFSM";
    }
}

