package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * This command is used to send a command to a sensor or effecter.
 *
 *
 *
 * Corresponding GameBots command is SET.
 *
 */
public class SetSensorEffecter extends CommandMessage
{
    //constructor for the joints
    public SetSensorEffecter(String Type, String Name, String Opcode, String param)
    {
        this.Type = Type;
        this.Name = Name;
        this.Opcode = Opcode;
        this.Params = param;
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * Setters to fill it up!
     */
    public SetSensorEffecter()
    {
    }
    /////// Properties BEGIN
    // the sensor or effecter’s type. 
    protected String Type = null;

    public String getType()
    {
        return Type;
    }

    public SetSensorEffecter setType(String Type)
    {
        this.Type = Type;
        return this;
    }
    //the sensor or effecter’s name.          
    protected String Name = null;

    public String getName()
    {
        return Name;
    }

    public SetSensorEffecter setName(String Name)
    {
        this.Name = Name;
        return this;
    }
    //the operation code. Different sensors or effecters.  Valid opcodes are defined in Section 8. of USARSim manual
    protected String Opcode = null;

    public String getOpcode()
    {
        return Opcode;
    }

    public SetSensorEffecter setOpcode(String Opcode)
    {
        this.Opcode = Opcode;
        return this;
    }
    //are the parameters associated with the operation command.
    protected String Params = null;

    public String getParam1()
    {
        return Params;
    }

    public SetSensorEffecter setParams(String Params)
    {
        this.Params = Params;
        return this;
    }

    /*
     * Example: SET {Type Odometry} {Name Odo1} {Opcode RESET} {Params 1}
     */
    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public SetSensorEffecter(SetSensorEffecter original)
    {
        this.Type = original.Type;
        this.Name = original.Name;
        this.Opcode = original.Opcode;
        this.Params = original.Params;
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        return super.toString()
                + "<b>Type</b> : "
                + String.valueOf(Type)
                + " <br/> "
                + "<b>Name</b> : "
                + String.valueOf(Name)
                + " <br/> "
                + "<b>Opcode</b> : "
                + String.valueOf(Opcode)
                + " <br/> "
                + "<b>Param1</b> : "
                + String.valueOf(Params)
                + " <br/> "
                + "";

    }

    public String toMessage()
    {
        StringBuilder buf = new StringBuilder();
        buf.append("SET");

        if(Type != null)
        {
            buf.append(" {Type ").append(Type).append("}");
        }

        if(Name != null)
        {
            buf.append(" {Name ").append(Name).append("}");
        }

        if(Opcode != null)
        {
            buf.append(" {Opcode ").append(Opcode).append("}");
        }

        if(Params != null)
        {
            buf.append(" {Params ").append(Params).append("}");
        }
        return buf.toString();
    }
}
