package cz.cuni.amis.pogamut.usar2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.SensorType;
import java.util.List;

/**
 *
 * Sensor message representative for Victim sensor.
 *
 * @author vejmanm
 */
public class SensorVictim extends SuperSensor
{
    //public static final String type="VictSensor";
    public static final SensorType type = SensorType.VICTIM_SENSOR;

    /**
     * Ctor. Sensor type describes particular subject about which we want to
     * know about. It is used to distinguish incoming message from the server.
     */
    public SensorVictim()
    {
        super(type);
    }

    /**
     * PartName is the name of the victim part that was discovered by the
     * sensor. It can be one of 7 values: “Head”, “Arm”, “Hand”, “Chest”,
     * “Pelvis”, “Leg”, and “Foot”. Please note that the sensor does not
     * differentiate between real victim’s part and false alarms. It is up to
     * the controller to perform this task.
     *
     * @param index
     * @return Returns victim body part name at given index.
     */
    public String getPartNameAt(int index)
    {
        if(index < getPartNamesSize())
        {
            return lastMessage.getPartNames().get(index);
        }
        else
        {
            return null;
        }
    }

    /**
     * List of Locations used by RFID sensor to determine where are various RFID
     * Tags or by Victiom sensor to determine locations of bodys. Also used by
     * INS sensor to determine robots location
     *
     * @param index
     * @return Returns location at given index.
     */
    public Location getLocationAt(int index)
    {
        if(index < getLocationSize())
        {
            return lastMessage.getLocations().get(index);
        }
        else
        {
            return null;
        }
    }

    /**
     * Return size of location list.
     *
     * @return Return size of location list.
     */
    public int getLocationSize()
    {
        return lastMessage.getLocations().size();
    }

    /**
     * Return size of victim body part name list.
     *
     * @return Return size of victim body part name list.
     */
    public int getPartNamesSize()
    {
        return lastMessage.getPartNames().size();
    }

    /**
     * PartName is the name of the victim part that was discovered by the
     * sensor. It can be one of 7 values: “Head”, “Arm”, “Hand”, “Chest”,
     * “Pelvis”, “Leg”, and “Foot”. Please note that the sensor does not
     * differentiate between real victim’s part and false alarms. It is up to
     * the controller to perform this task.
     *
     * @return Returns a list of victim body part names.
     */
    public List<String> getPartNames()
    {
        return lastMessage.getPartNames();
    }

    /**
     * Status is not in USARSim manual v3.1.3. And was added to full support of
     * Victim sensor.
     *
     * @return Returns the status of Victim sensor.
     */
    public String getStatus()
    {
        return lastMessage.getStatus();
    }
}
