package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * Drive command specified for a joint.
 *
 * Corresponding GameBots command is DRIVE.
 *
 */
public class DriveJoint extends CommandMessage
{
    //constructor for the sixth type
    public DriveJoint(String Name, int Steer, int Order, double Value)
    {
        this.Name = Name;
        this.Steer = Steer;
        this.Order = Order;
        this.Value = Value;
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * setters to fill it up!
     */
    public DriveJoint()
    {
    }
    /////// Properties BEGIN
    //sixth type - Name, Steer, Order, Vlaue
    //the joint name
    protected String Name = null;

    public String getName()
    {
        return Name;
    }

    public DriveJoint setName(String Name)
    {
        this.Name = Name;
        return this;
    }
    //the steer angle of the joint
    protected int Steer = 0;

    public int getSteer()
    {
        return Steer;
    }

    public DriveJoint setSteer(int Steer)
    {
        this.Steer = Steer;
        return this;
    }
    /*
     * the control mode. It can be 0-2. 0: zero-order control. It controls
     * rotation angle. 1: first-order control. It controls spin speed. 2:
     * second-order control. It controls torque.
     */
    protected int Order = 0;

    public int getOrder()
    {
        return Order;
    }

    public DriveJoint setOrder(int Order)
    {
        this.Order = Order;
        return this;
    }
    /*
     * the control value. For zero-order control, it’s the rotation angle in
     * radians. For first-order control, it’s the spin speed in radians/second.
     * For second-order control, it’s the torque.
     */
    protected double Value = 0;

    public double getValue()
    {
        return Value;
    }

    public DriveJoint setValue(double Value)
    {
        this.Value = Value;
        return this;
    }

    /*
     * Example: DRIVE {Name LeftFWheel} {Steer 1.57} will steer the left front
     * wheel 90 degrees. DRIVE {Name LeftFWheel} {Order 1} {Value 0.175} will
     * make the left front wheel spin at 0.175 radians/second, i.e. 10
     * degrees/second
     */
    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public DriveJoint(DriveJoint original)
    {
        this.Name = original.Name;
        this.Steer = original.Steer;
        this.Order = original.Order;
        this.Value = original.Value;
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        return super.toString()
                + "<b>Name</b> : "
                + String.valueOf(Name)
                + " <br/> "
                + "<b>Steer</b> : "
                + String.valueOf(Steer)
                + " <br/> "
                + "<b>Order</b> : "
                + String.valueOf(Order)
                + " <br/> "
                + "<b>Value</b> : "
                + String.valueOf(Value)
                + " <br/> "
                + "";
    }

    public String toMessage()
    {

        StringBuilder buf = new StringBuilder();
        buf.append("DRIVE");

        if(Name != null)
        {
            buf.append(" {Name ").append(Name).append("}");
        }
        buf.append(" {Steer ").append(Steer).append("}");
        buf.append(" {Order ").append(Order).append("}");
        buf.append(" {Value ").append(Value).append("}");

        return buf.toString();
    }
}
