package cz.cuni.amis.pogamut.usar2004.agent.module.configuration;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.ConfigType;

/**
 * Configuration message representative for Mission packages.
 *
 * @author vejmanm
 */
public class ConfigMissionPackage extends SuperConfiguration
{
    public static final ConfigType type = ConfigType.MISSION_PACKAGE;

    /**
     * Ctor. Configuration type describes particular subject about which
     * we want to know about. It is used to distinguish incoming message from
     * the server.
     */
    public ConfigMissionPackage()
    {
        super(type);
    }

    /**
     *
     * Each value is the mission package’s link number(or index) that is
     * described further by JoinType, Max/Min Torque, Max/Min Speed and Max/Min
     * Range.
     *
     * @param index
     * @return Returns link value at given index.
     */
    public int getLinkAt(int index)
    {
        return lastMessage.getLinks().get(index);
    }

    /**
     *
     * Each value can either be “Revolute” or “Prismatic”, as determined by the
     * type of joint being described.
     *
     * @param index
     * @return Returns joint type value at given index.
     */
    public String getJointTypeAt(int index)
    {
        return lastMessage.getJointTypes().get(index);
    }

    /**
     *
     * Each value describes the joint’s maximum speed, in rad/s.
     *
     * @param index
     * @return Returns joint max speed at given index.
     */
    public double getMaxSpeedAt(int index)
    {
        if(index < getLinksLength())
        {
            return lastMessage.getMaxSpeeds().get(index);
        }
        return -1;
    }

    /**
     *
     * Each value describes the joint’s maximum torque.
     *
     * @param index
     * @return Returns joint max torque at given index.
     */
    public double getMaxTorqueAt(int index)
    {
        if(index < getLinksLength())
        {
            return lastMessage.getMaxTorques().get(index);
        }
        return -1;
    }

    /**
     * For a revolute joint, Each value is the minimum absolute angle that the
     * joint can rotate to. For a prismatic joint, Each value is the minimum
     * distance that the joint can move to.
     *
     * @param index
     * @return Returns joint min range at given index.
     */
    public double getMinRangeAt(int index)
    {
        if(index < getLinksLength())
        {
            return lastMessage.getMinRanges().get(index);
        }
        return -1;
    }

    /**
     * For a revolute joint, Each value is the maximum absolute angle that the
     * joint can rotate to. For a prismatic joint, Each value is the maximum
     * distance that the joint can move to.
     *
     * @param index
     * @return Returns joint max range at given index.
     */
    public double getMaxRangeAt(int index)
    {
        if(index < getLinksLength())
        {
            return lastMessage.getMaxRanges().get(index);
        }
        return -1;
    }

    /**
     * Returns length of link list.
     * @return Returns length of link list.
     */
    public int getLinksLength()
    {
        return lastMessage.getLinks().size();
    }
}
