package cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands;

import cz.cuni.amis.pogamut.base.communication.messages.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.datatypes.CustomTypes.*;

/**
 *
 * There are two types of query command. One queries the geometry information,
 * and another queries the configuration information.
 *
 * Corresponding GameBots command is GETGEO.
 *
 */
public class GetGeo extends CommandMessage
{
    public GetGeo(String Type, String Name)
    {
        this.Type = Type;
        this.Name = Name;
    }

    /**
     * <p></p>WARNING: this is empty-command constructor, you have to use
     * setters to fill it up!
     */
    public GetGeo()
    {
    }
    /////// Properties BEGIN
    protected String Type = null;

    public String getType()
    {
        return Type;
    }

    public GetGeo setType(String Type)
    {
        this.Type = Type;
        return this;
    }
    /*
     * The “{Name string}” is optional. If it’s omitted, the command queries the
     * geometry information for all the sensors/effecters with the specified
     * type. Otherwise, only the sensor/effecter with the name and type will be
     * queried. The return message is a GEO message.
     */
    protected String Name = null;

    public String getName()
    {
        return Name;
    }

    public GetGeo setName(String Name)
    {
        this.Name = Name;
        return this;
    }

    /*
     * Example: GETGEO {Type Sonar} GETGEO {Type MisPkg} GETGEO {Type Robot}
     * GETGEO {Type Effecter}
     */
    /////// Properties END
    /////// Extra Java code BEGIN
    /////// Additional code from xslt BEGIN
    /////// Additional code from xslt END
    /////// Extra Java from XML BEGIN
    /////// Extra Java from XML END
    /////// Extra Java code END
    /**
     * Cloning constructor.
     */
    public GetGeo(GetGeo original)
    {
        this.Type = original.Type;
        this.Name = original.Name;
    }

    @Override
    public String toString()
    {
        return toMessage();
    }

    public String toHtmlString()
    {
        return super.toString()
                + "<b>Type</b> : "
                + String.valueOf(Type)
                + " <br/> "
                + "<b>Name</b> : "
                + String.valueOf(Name)
                + " <br/> "
                + "";
    }

    public String toMessage()
    {
        StringBuilder buf = new StringBuilder();

        buf.append("GETGEO");

        if(Type != null)
        {
            buf.append(" {Type ").append(Type).append("}");
        }

        if(Name != null)
        {
            buf.append(" {Name ").append(Name).append("}");
        }
        return buf.toString();
    }
}
