package cz.cuni.amis.pogamut.usar2004.agent.module.geometry;

import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.GeometryType;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

/**
 * Geometry message representative for Vehicles - Ground, Aerial, Legged and
 * Nautic share properties present here.
 *
 * @author vejmanm
 */
public abstract class VehicleGeometry extends SuperGeometry
{
    /**
     * Ctor.
     *
     * @param type Geometry type describes particular subject about which we
     * want to know about. It is used to distinguish incoming message from the
     * server.
     */
    public VehicleGeometry(GeometryType type)
    {
        super(type);
    }

    /**
     * Dimension (x,y,z) ‘x’ defines the robot’s length, ‘y’ defines the robot’s
     * width, and ‘z’ describes the robot’s height. Please note that these
     * values are in meters.
     *
     * @return Returns Dimension of the robot.
     */
    public Vector3d getDimensions()
    {
        return lastMessage.getDimensions();
    }

    /**
     * COG(x,y,z) ‘x’, ‘y’, and ‘z’ identify the position of the center of
     * gravity, in meters, calculated from the chassis origin.
     *
     * @return Returns center of gravity of the robot
     */
    public Point3d getCenterOfGravity()
    {
        return lastMessage.getCenterOfGravity();
    }
}
