package cz.cuni.amis.pogamut.usar2004.agent.module.datatypes;

import cz.cuni.amis.pogamut.usar2004.agent.module.geometry.*;

/**
 * List of all Robot geometry Types. Each type can possibly represent more kinds
 * of geometry of same type. For each enum record, there exists relevant Class
 * which can be returned on demand.
 *
 * @author vejmanm
 */
public enum GeometryType
{
    GROUND_VEHICLE(GeoGround.class, "GroundVehicle"),
    LEGGED_ROBOT(GeoLegged.class, "LeggedRobot"),
    NAUTIC_VEHICLE(GeoNautic.class, "NauticVehicle"),
    AERIAL_VEHICLE(GeoAerial.class, "AerialVehicle"),
    SENSOR_EFFECTER(GeoSensorEffecter.class, "Sensor", "Effecter"),
    MISSION_PACKAGE(GeoMissionPackage.class, "MisPkg");
    private String[] kinds;
    private Class clazz;

    /**
     *
     * @param type - type of the geometry message
     * @param clazz - class that carries data about this type of geometry
     */
    GeometryType(Class clazz, String... kinds)
    {
        this.kinds = kinds;
        this.clazz = clazz;
    }

    /**
     * For each geometry type it checks if <B>type</B> matches one of
     * <B>kinds</B>. If so, it returns relevant GeometryType. Notice that this
     * method is static. If nothing matches, it returns SENSOR_EFECTER
     *
     * @param type String representation or kind of Geometry
     * @return Returns relevant GeometryType value to the String <B>type</B>
     */
    public static GeometryType getType(String type)
    {
        for(GeometryType geoType : GeometryType.values())
        {
            for(String kind : geoType.kinds)
            {
                if(kind.equalsIgnoreCase(type))
                {
                    return geoType;
                }
            }
        }
        return SENSOR_EFFECTER;
    }

    /**
     * Notice that this method is not static.
     *
     * @return Returns class relevant to Actual GeometryType
     */
    public Class getModuleClass()
    {
        return this.clazz;
    }
}
