package cz.cuni.amis.pogamut.usar2004.agent.module.datatypes;

import cz.cuni.amis.pogamut.usar2004.agent.module.configuration.*;

/**
 * List of all Robot config Types. Each type can possibly represent more kinds
 * of config of same type. For each enum record, there exists relevant Class
 * which can be returned on demand.
 *
 * @author vejmanm
 */
public enum ConfigType
{
    GROUND_VEHICLE(ConfigGround.class, "GroundVehicle"),
    LEGGED_ROBOT(ConfigLegged.class, "LeggedRobot"),
    NAUTIC_VEHICLE(ConfigNautic.class, "NauticVehicle"),
    AERIAL_VEHICLE(ConfigAerial.class, "AerialVehicle"),
    SENSOR(ConfigSensor.class, "Sensor"),
    EFFECTER(ConfigEffecter.class, "Effecter"),
    MISSION_PACKAGE(ConfigMissionPackage.class, "MisPkg");
    private String kind;
    private Class clazz;

    /**
     *
     * @param type - type of the config message
     * @param clazz - class that carries data about this type of config
     */
    ConfigType(Class clazz, String kind)
    {
        this.kind = kind;
        this.clazz = clazz;
    }

    /**
     * For each config type it checks if <B>type</B> matches one of
     * <B>kinds</B>. If so, it returns relevant ConfigType. Notice that this
     * method is static. If nothing matches, it returns SENSOR
     *
     * @param type String representation or kind of Config
     * @return Returns relevant ConfigType value to the String <B>type</B>
     */
    public static ConfigType getType(String type)
    {
        for(ConfigType geoType : ConfigType.values())
        {
            if(geoType.kind.equalsIgnoreCase(type))
            {
                return geoType;
            }
        }
        return SENSOR;
    }

    /**
     * Notice that this method is not static.
     *
     * @return Returns class relevant to Actual ConfigType
     */
    public Class getModuleClass()
    {
        return this.clazz;
    }
}
