package cz.cuni.amis.pogamut.usar2004.samples;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.usar2004.agent.*;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.DriveSkid;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarcommands.Initialize;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.ConfigurationMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.GeometryMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.MissionPackageMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.NfoMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.ResponseMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.SensorMessage;
import cz.cuni.amis.pogamut.usar2004.communication.messages.usarinfomessages.StateMessage;
import cz.cuni.amis.pogamut.usar2004.utils.*;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;

/**
 * Testing bot controller for spawning various robots and testing unknown sensors and info messages.
 * @author vejmanm
 */
@AgentScoped
public class USAR2004TestBot extends USAR2004BotController {

    @Override
    public void initializeController(USAR2004Bot bot) {
        //is not called!
        super.initializeController(bot);
    }
/**
     * Initialization of listeners.
     *
     * @param bot Necessary parameter for hooking listeners and for sending
     * commands
     */
    @Override
    public void prepareBot(USAR2004Bot bot) {
        
        //is not called!
        super.prepareBot(bot);
        
        
        //System.out.println(new Drive(-1, -1, false, false, false).toMessage());
        //System.out.println(new Initialize("USARBot.P3AT", "mujRobot", new Location(0.76,2.3,1.8)))
//        System.out.println(new Initialize("USARBot.ExampleAckerman", null, new Location(0.4,0.4,1.8)).toMessage());
//        
//        getAct().act(new Initialize());//"USARBot.P2DX", "R1", new Location(4.5, 1.9, 1.8)));
        
        getWorldView().addEventListener(ConfigurationMessage.class, confList);        
        getWorldView().addEventListener(StateMessage.class, statList);        
        getWorldView().addEventListener(SensorMessage.class, sensorList);        
        getWorldView().addEventListener(ResponseMessage.class, respList);            
        getWorldView().addEventListener(MissionPackageMessage.class, missList);        
        getWorldView().addEventListener(GeometryMessage.class, geoList);        
        getWorldView().addEventListener(NfoMessage.class, nfoList);        
        Map<Class, Map<WorldObjectId, IViewable>> allVisible = getWorldView().getAllVisible();
        
        System.out.println(allVisible.size());
        System.out.println("TEST");
    }
    
    
    IWorldEventListener<NfoMessage> nfoList = new IWorldEventListener<NfoMessage>() {

        @Override
        public void notify(NfoMessage t) {
            System.out.println("INFO INFO FOR STARTERS"  + t.toString());
            if(!first){
                //INIT {ClassName USARBot.P2DX} {Location 4.5,1.9,1.8}
                //getAct().act(new Initialize("USARBot.P2DX", "Blimp", new Location(4.5,1.9,1.8), null));
                getAct().act(new Initialize("USARBot.P3AT", "Item" ,new Location(0.6903,4.7984, 7.8320),null));
                first=true;
            }//new Location(-4.2861,40.1280,4.6800),null));//0.76,2.3,1.8),null));
        }
    };
    
    IWorldEventListener<GeometryMessage> geoList = new IWorldEventListener<GeometryMessage>() {

        @Override   
        public void notify(GeometryMessage t) {
            System.out.println("GEOMETRY GEOMETRY"  + t.toString());
        }
    };

    IWorldEventListener<MissionPackageMessage> missList = new IWorldEventListener<MissionPackageMessage>() {

        @Override
        public void notify(MissionPackageMessage t) {
            System.out.println("MISSION PACKAGE MISSION PACKAGE"  + t.toString());
            
//            getAct().act(new Initialize("USARBot.ExampleAckerman", null, new Location(0.4,0.4,1.8)));            //throw new UnsupportedOperationException("Not supported yet.");

        }
    };
    
    IWorldEventListener<ResponseMessage> respList = new IWorldEventListener<ResponseMessage>() {

        @Override
        public void notify(ResponseMessage t) {
            System.out.println("RESPONSE MESSAGE RESPONSE MESSAGE"  + t.toString());

        }
    };
    
    IWorldEventListener<SensorMessage> sensorList = new IWorldEventListener<SensorMessage>() {

        @Override
        public void notify(SensorMessage t) {
            //System.out.println("SENSOR MESSAGE SENSOR MESSAGE"  + t.toString());
            if(t.getLaserRanges().size()>1){
                ArrayList<Double> f=new ArrayList<Double>();
                f.addAll(t.getLaserRanges());
                RangesReady(f);
                
            }
        }
    };
        
     
    private void driveLeft(){
        System.out.println("left");
            right=15;
            left=5;
    }
    private void driveRight(){
        System.out.println("right");
            right=4;
            left=15;
    }
    
    
    private void driveStraight(){
        System.out.println("straight");
        right=15;
        left=15;
    }
    private void driveBackwards(){
        System.out.println("back");
        if(step>10)
        {
         right=-3;
         left=-3;
        }
        else{
            right=-3;
            left=3;
        }
        step--;
        if(step==0){
            step=20;
            reversActive=false;
        }
            
    }
    
    private int step=20;   
    boolean reversActive=false;
    public void RangesReady(ArrayList<Double> Ranges) {
        
        int third = Ranges.size()/3;
        double mleft=0, mright=0,mstraight=0;
        for (int i = 0; i <  Ranges.size(); i++) {
            if(i<third){
                mright+= Ranges.get(i);
            }
            else if(i<2*third){
                mstraight+= Ranges.get(i);
            }
            else
            {
                mleft+= Ranges.get(i);                
            }
        }
            System.out.println(mleft+" "+mstraight+" "+mright);
        if(reversActive||mleft+mstraight<200||mright+mstraight<200){
            reversActive=true;
            driveBackwards();
        }
        else{
           //if(mleft+mstraight<500||mright+mstraight<500)
            {
                if(Math.max(mleft, mright)==mleft)
                {
                    if(Math.max(mleft, mstraight)==mleft)
                        driveLeft();
                    else
                        driveStraight();
                }
                else{

                    if(Math.max(mright, mstraight)==mright)
                        driveRight();
                    else
                        driveStraight();
                }
            }
            //else driveStraight();
        }
    }
    
    
    IWorldEventListener<StateMessage> statList = new IWorldEventListener<StateMessage>() {

        @Override
        public void notify(StateMessage t) {
            //System.out.println("STATE MESSAGE STATE MESSAGE"  + t.toString());
            logic();
        }
    };
    
    IWorldEventListener<ConfigurationMessage> confList = new IWorldEventListener<ConfigurationMessage>() {

        @Override
        public void notify(ConfigurationMessage t) {
            System.out.println("CONFIGURATION CONFIGURATION"  + t.toString());

        }
    };

    public static void main(String[] args) {

        //to set logging level change the setLogLevel attribute
        new USAR2004BotRunner(USAR2004TestBot.class, "PogamutBotBot", "127.0.0.1",3000).setMain(true).setLogLevel(Level.WARNING).startAgent();
        //new USAR2004BotRunner(USAR2004TestBot.class, "PogamutBotBot", "216.93",3000).setMain(true).setLogLevel(Level.ALL).startAgent();
    }
    
    boolean first = false;
    int left=0, right=0;
    
    public void logic(){
               
        //udělat čtení z lejzr senzoru třetina vlevo, třetina vpravo třetina veprostřed/polovina vlevo-pravo
         getAct().act(new DriveSkid(left,right, false, false, false));
//           switch (lf.getDirection()) {
//               case 's' : getAct().act(new DriveSkid(lf.getLeft(),lf.getRight(), false, true, false));
                   //break;
//               case 'w' :
//                   getAct().act(new GetGeo("Robot", null));
//                   break;
//               case 'e' :
//                   getAct().act(new MissionPackage("kr3Arm", 1, 2.4f, 0));
//                   break;
//               case 'd' :
//                   getAct().act(new DriveSkid(lf.getLeft(), lf.getRight(), false, true, false));//new DriveAerial(lf.getAirValues()[0], lf.getAirValues()[1],lf.getAirValues()[2], lf.getAirValues()[3], false));
//                   break;
//               default:
//                   getAct().act(new SetCamera("Camera", "Camera", lf.getLeft()));
//                   break;


                           
                           
                           
                   
               //getAct().act(new GetConf("MisPkg", null));
               
               //first=false;
               //System.out.println("Heres some drivin!");
           //}
            

    }
    
}

