package cz.cuni.amis.pogamut.usar2004.samples.AirScanner;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

/**
 * ToolBox class covers methods that help solve comon/easy tasks.
 *
 * @author vejmanm
 */
public class ToolBox
{
    /**
     * Returns maximum value from the input array.
     *
     * @param array Input array.
     * @return Returns maximum value within the array.
     */
    public static int getMax(int[] array)
    {
        int max = 0;
        for(int i : array)
        {
            if(i > max)
            {
                max = i;
            }
        }
        return max;
    }

    /**
     * Uses DateFormat to format the input value to hours, minutes, seconds and
     * mili seconds.
     *
     * @param elapsed Elapsed time in miliseconds.
     * @return Returns string time formated as HH:mm:ss.SSS.
     */
    public static String getTime(long elapsed)
    {
        DateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
        df.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        return (df.format(new Date(elapsed)));
    }

    /**
     * Uses Math.min method to determine the minimum of the four input values.
     *
     * @param i first number
     * @param j second number
     * @param k third nubmer
     * @param l fourth number
     * @return Returns minimal value from the four input integers
     */
    public static int getMin(int i, int j, int k, int l)
    {
        return Math.min(Math.min(i, j), Math.min(k, l));
    }

    /**
     * Determines an angle in degrees based on sin and cos of the angle.
     *
     * @param sx Sinus x
     * @param cx Cosinus x
     * @return Returns angle in degrees.
     */
    public static double getAngle(double sx, double cx)
    {
        if(sx > 0 && cx > 0)
        {
            return Math.acos(Math.abs(cx)) * 180 / Math.PI;
        }
        else if(sx > 0 && cx <= 0)
        {
            return 180 - Math.acos(Math.abs(cx)) * 180 / Math.PI;
        }
        else if(sx <= 0 && cx <= 0)
        {
            return 180 + Math.acos(Math.abs(cx)) * 180 / Math.PI;
        }
        else
        {
            return 360 - Math.acos(Math.abs(cx)) * 180 / Math.PI;
        }
    }

    /**
     * Uses DecimalFormat to format the <B>value</B>.
     *
     * @param value Double value to convert to string.
     * @return Returns string representation of the <b>value</b> formated to two
     * decimal places.
     */
    public static String getTwoDecimalPlaces(double value)
    {
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(value);
    }

    /**
     * Creates new a image enlarged by <b>x</b> and <b>y</b> and draws old image
     * at <b>offsetX</b>, <b>offsetY</b>.
     *
     * @param original Original image to be stretched.
     * @param x Widht enlargement.
     * @param y Height enlargement.
     * @param offsetX Offset for original picture to be drawn at x-axis.
     * @param offsetY Offset for original picture to be drawn at y-axis.
     * @return Returns narger image with black background.
     */
    public static BufferedImage resizeImage(Image original, int x, int y, int offsetX, int offsetY)
    {
        BufferedImage resized = new BufferedImage(original.getWidth(null) + x, original.getHeight(null) + y, BufferedImage.TYPE_INT_ARGB);
        Graphics2D g = resized.createGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, resized.getWidth(), resized.getHeight());
        g.drawImage(original, offsetX, offsetY, null);
        return resized;
    }

    /**
     * Creates new array enlongated by <b>x</b> and <b>y</b> and fills it with
     * old walues at <b>offsetX</b>, <b>offsetY</b>.
     *
     * @param original Original array to be lengthened.
     * @param x Width enlargement.
     * @param y Height enlargement.
     * @param offsetX Offset for original data at x-axis.
     * @param offsetY Offset for original data at y-axis.
     * @return Returns resized array.
     */
    public static double[][] resizeArray(double[][] original, int x, int y, int offsetX, int offsetY)
    {
        double[][] resized = initArray(original.length + x, original[0].length + y);

        for(int i = 0; i < original.length; i++)
        {
            System.arraycopy(original[i], 0, resized[i + offsetX], offsetY, original[0].length);
        }
        return resized;
    }

    /**
     * Initial value will be Double.MIN_VALUE. Zeroes would be missunderstood
     * while creating an image.
     */
    public static double[][] initArray(int width, int height)
    {
        double data[][] = new double[width][height];
        for(int i = 0; i < data.length; i++)
        {
            for(int j = 0; j < data[i].length; j++)
            {
                data[i][j] = Double.MIN_VALUE;
            }
        }
        return data;
    }
}
