/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.usar2004.samples.AirScanner;

/**
 * List risk levels. By the risk level robot determines its reactive behaviour
 * when facing some obstacles.
 *
 * @author vejmanm
 */
public enum RiskLevel
{
    HIGHRISK(2),
    LOWRISK(1),
    NORISK(0);
    private int intRisk;

    RiskLevel(int risk)
    {
        this.intRisk = risk;
    }

    public static RiskLevel getGreaterRisk(RiskLevel lvlA, RiskLevel lvlB)
    {
        return (lvlA.intRisk > lvlB.intRisk)?lvlA:lvlB;
    }

    public boolean isGreaterRisk(RiskLevel than)
    {
        return this.intRisk > than.intRisk;
    }
    public boolean isGreaterOrEqualRisk(RiskLevel than)
    {
        return this.intRisk >= than.intRisk;
    }
}
