package cz.cuni.amis.pogamut.unreal.communication.messages;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.utils.token.Token;

/**
 * Interface that is returning an unique id of the world object. The id must be unique
 * among all the objects in the world.
 * <p><p>
 * hashmaps/sets.
 * 
 * @author Jimmy
 */
public class UnrealId extends WorldObjectId implements Serializable {
	
	/**
	 * For wrappers...
	 */
	protected UnrealId() {
		super("wrapper");
	}
	
	private UnrealId(String name) {
		super(name);
	}
	
	private UnrealId(Token name) {
		super(name);
	}
	
	private UnrealId(UnrealId name) {
		super(name.token);
	}
	
	private static Map<String, UnrealId> map = new HashMap<String, UnrealId>();

	/**
	 * <p>
	 * Note that if you run some map from cmdline, NavPoint-s name prefix is generated
	 * case censitive. So on win platform you can run map "CtF-losTFAith", which will
	 * start correct map (file system not case sensitive) and navpoints will be
	 * seen with different prefix name as if you start map "CTF-LostFaith".
	 * </p>
	 *
	 * @param name
	 * @return
	 */
	public static UnrealId get(String name) {
		UnrealId id = null;
		id = map.get(name);
		if (id != null) return id;
		synchronized(map) {
			id = map.get(name);
			if (id != null) return id;
			id = new UnrealId(name);
			map.put(name, id);
			return id;
		}
	}
	
	
}
