package cz.cuni.amis.pogamut.udk.bot.impl;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.junit.Assert;
import org.junit.Test;

import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.udk.bot.impl.test.BotTestContext;
import cz.cuni.amis.pogamut.udk.bot.impl.test.ConcurrentBot;
import cz.cuni.amis.pogamut.udk.bot.impl.test.LeakTestBot;
import cz.cuni.amis.pogamut.udk.bot.impl.test.LeakTestBotFactory;
import cz.cuni.amis.pogamut.udk.bot.impl.test.PauseResumeBotTest;
import cz.cuni.amis.pogamut.udk.test.BaseUDKTest;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.test.Repeater;

public class UDKTest10_LeakTestBot_Direct extends BaseUDKTest {
	
	private static class MasterTest implements Runnable {

		private Logger log;
		private SocketConnectionAddress address;

		public MasterTest(Logger log, SocketConnectionAddress address) {
			this.log = log;
			this.address = address;
		}
		
		@Override
		public void run() {
			/*IAgentFactory*/ LeakTestBotFactory factory = new LeakTestBotFactory(); //Somehow this did not compile with the interface declaration
	    	BotTestContext testCtx = new BotTestContext(log, factory, address);
	    	new Repeater<BotTestContext>(1, new ConcurrentBot(4, new PauseResumeBotTest())).run(testCtx);
	    	
	    	factory = null;
	    	testCtx = null;
		}
		
	}
	
	@Test
    public void test() {
		Thread t = new Thread(new MasterTest(log, ucc.getBotAddress()), "MasterTest");		
		t.start();
		try {
			t.join();
		} catch (InterruptedException e) {
			throw new PogamutInterruptedException(e, this);
		}
		t = null;
    	
    	for (int i = 0; i < 120; ++i) {
    		System.gc();
    		Integer value = LeakTestBot.getInstances().waitFor((long)1000, 0);
    		if (value != null && value == 0) {
    			System.out.println("All instances of LeakTestBot has been gc()ed.");
    			System.out.println("---/// TEST OK ///---");
    			return;
    		} else {
    			if (log.isLoggable(Level.INFO)) log.info("/" + (i+1) + " sec" + (i != 0 ? "s" : "") + "/ LeakTestBot.instances = " + LeakTestBot.getInstances().getFlag());
    		}
    	}
    	
    	String str = "Not all LeakTestBot instances were gc()ed in 120secs after the test ended, LeakTestBot.instances = " + LeakTestBot.getInstances().getFlag() + ".";
    	if (log.isLoggable(Level.SEVERE)) log.severe(str);
    	Assert.fail(str);
    }
	
}
