package cz.cuni.amis.pogamut.udk.factory.guice.remoteagent;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.params.IRemoteAgentParameters;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.udk.agent.params.UDKAgentParameters;
import cz.cuni.amis.pogamut.udk.bot.IUDKBot;

/**
 * Guice-base {@link IUDKBot} factory. It needs {@link UDKBotModule} to work correctly and the module is required
 * to bound {@link IAgent} to the {@link IUDKBot}, otherwise the method {@link UDKBotFactory#newAgent(IRemoteAgentParameters)}
 * will throw {@link ClassCastException}.
 * <p><p>
 * For more info about the factory, see {@link GuiceAgentFactory}.
 *
 * @author Jimmy
 *
 * @param <BOT>
 * @param <PARAMS>
 */
public class UDKBotFactory<BOT extends IUDKBot, PARAMS extends UDKAgentParameters> extends GuiceAgentFactory<BOT, PARAMS> {

	public UDKBotFactory(UDKBotModule<PARAMS> agentModule) {
		super(agentModule);
	}
	
	@Override
	protected UDKBotModule<PARAMS> getAgentModule() {
		return (UDKBotModule<PARAMS>) super.getAgentModule();
	}
	
}
