package cz.cuni.amis.pogamut.udk.agent.navigation.stuckdetector;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;

public class UDKPositionHistoryStuckDetector implements IStuckDetector {

	private static double DEFAULT_MIN_DIAMETER = 70.0;
	
	private static double DEFAULT_MIN_Z = 100.0;
	
	private static int DEFAULT_HISTORY_LENGTH = 4;
	
	private UDKBot bot;
	
	private double minMovementDiameter;
	
	private int historyLength;
	
	private List<Location> locationHistory;
	
	private boolean stuck = false;

        /**
         * @todo not implemented
         * @param state
         */
    public void setBotWaiting(boolean state) {

    }

	private class SelfListener implements IWorldObjectListener<Self> {

		public SelfListener(IWorldView worldView) {
			worldView.addObjectListener(Self.class, this);
		}
		
		@Override
		public void notify(IWorldObjectEvent<Self> event) {
			eventSelf(event);
		}
		
	};
	
	private SelfListener selfListener;
	
	private Logger log;

	private double minMovementZ;
	
	public UDKPositionHistoryStuckDetector(UDKBot bot) {
		this(bot, DEFAULT_HISTORY_LENGTH, DEFAULT_MIN_DIAMETER, DEFAULT_MIN_Z);
	}
	
	public UDKPositionHistoryStuckDetector(UDKBot bot, int historyLength, double minMovementDiameter, double minMovementZ) {
		if (this.log == null) {
			this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
		}
		this.bot = bot;		
		selfListener = new SelfListener(bot.getWorldView());
		
		this.historyLength = historyLength;
		
		if (this.historyLength < 0) throw new IllegalArgumentException("historyLenght can't be < 0");
		
		this.minMovementDiameter = minMovementDiameter;
		this.minMovementZ = minMovementZ;
		
		this.locationHistory = new ArrayList<Location>(this.historyLength);		
	}
		
	public void eventSelf(IWorldObjectEvent<Self> event) {
		locationHistory.add(event.getObject().getLocation());
		while (locationHistory.size() > historyLength) {
			locationHistory.remove(0);
		}
		
		if (locationHistory.size() == historyLength) {
			double maxDistance = Double.NEGATIVE_INFINITY;
			double maxHeight = Double.NEGATIVE_INFINITY;
			for (Location loc1 : locationHistory){
				for (Location loc2: locationHistory) {
					if (maxDistance < loc1.getDistance2D(loc2)) {
						maxDistance = loc1.getDistance2D(loc2);
					}
					if (Math.abs(loc1.z - loc2.z) > maxHeight) {
						maxHeight = Math.abs(loc1.z - loc2.z);
					}
				}
			}
			if (maxDistance < this.minMovementDiameter && maxHeight < this.minMovementZ) {
				stuck = true;
			} else {
				stuck = false;
			}
		}
		
	}

	
	@Override
	public boolean isStuck() {
		return stuck;
	}

	@Override
	public void reset() {
		this.locationHistory.clear();
		stuck = false;
	}

}
