package cz.cuni.amis.pogamut.udk.communication.worldview;

import java.io.File;
import java.util.Collection;

import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.udk.communication.worldview.UDKSyncLockableWorldView;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.PlanFileNameLoader;
import cz.cuni.amis.pogamut.udk.component.ComponentStub;

@RunWith(value=Parameterized.class)
public class Test01_UDKSyncLockableWorldView extends AbstractSyncWorldViewTest {
		
	public Test01_UDKSyncLockableWorldView(File planFile) {
		super(planFile);
	}

	@Parameters
	public static Collection<File[]> data() {
		return PlanFileNameLoader.loadPlanFileNames(UDKSyncLockableWorldView.class);
	}

	@Override
	protected IWorldView createWorldView(IAgentLogger logger, ComponentBus bus,
			ComponentStub worldViewController, MockMediator mockMediator) {
		return new UDKSyncLockableWorldView(new ComponentDependencies().add(worldViewController), mockMediator, bus, logger);
	}

	@Override
	protected void preTest() {
	}
	
}
