package cz.cuni.amis.pogamut.udk.utils;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutProperty;
import cz.cuni.amis.utils.exception.PogamutIOException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;

/**
 * Wrapper of the UDK instance. Can be used for launching the game in spectate mode.
 * @author ik
 */
public class UDKWrapper {

    public static void launchSpectate(URI serverUri) throws IOException {
        String udkHomeProp = Pogamut.getPlatform().getProperty(PogamutUDKProperty.POGAMUT_UNREAL_HOME.getKey());
        if(udkHomeProp == null) throw new PogamutIOException(
                "Property " + PogamutUDKProperty.POGAMUT_UNREAL_HOME.getKey() + " not set. Set it to point to the UDK home directory. You can do this in environments variables.", null);
        String path = udkHomeProp + File.separator + "System" + File.separator;
        List<String> cmds = null;
        if (!System.getProperty("os.name").contains("Windows")) {
            // TODO how to start in UNIX?
        } else {
            path += "UDK.exe";
            // TODO deal with multiple uccs on one host
            // get IP
            InetAddress adr = InetAddress.getByName(serverUri.getHost());
            cmds = Arrays.asList("cmd.exe",
                    "/c",
                    "start \"UDK Spectate\" /low \"" + path + "\" " + adr.getHostAddress());
        }

        ProcessBuilder builder = new ProcessBuilder(cmds);
        Process ut = builder.start();
    }
}
