package cz.cuni.amis.pogamut.udk.communication.worldview.testplan.wrapper;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;

/**
 * Wraps input events along with how many times it should be raised.
 * @author Radek 'Black_Hand' Pibil
 *
 */
@XStreamAlias("InputEventWrapper")
public class InputEventWrapper {
	@XStreamAsAttribute
	private final int raiseTimes;
	@XStreamAlias("Event")
	private final IWorldChangeEvent event;
	
	public InputEventWrapper(IWorldChangeEvent event, int raiseTimes) {
		this.event = event;
		this.raiseTimes = raiseTimes;
	}
	
	public int getRaiseTimes() {
		return raiseTimes;
	}
	
	public IWorldChangeEvent getEvent() {
		return event;
	}
}
