/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.FieldName;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.KismetInputLink;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.KismetLinkTarget;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.KismetOutputLink;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.KismetVariableLink;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.UnrealReference;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.AbstractUnrealObject;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.kismet.Sequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractKismetObject
extends AbstractUnrealObject {
    private transient Map<String, Integer> inputLinksMapping = new HashMap<String, Integer>();
    private transient Map<String, Integer> outputLinksMapping = new HashMap<String, Integer>();
    private transient Map<String, Integer> variableLinksMapping = new HashMap<String, Integer>();
    private List<KismetInputLink> inputLinks;
    private List<KismetOutputLink> outputLinks;
    private List<KismetVariableLink> variableLinks;
    private Sequence parentSequence;
    @FieldName(value="ObjInstanceVersion")
    private Integer instanceVersion = 1;
    private String objComment;
    private Boolean outputObjCommentToScreen;
    private Boolean suppressAutoComment;
    private Integer objPosX;
    private Integer objPosY;

    public AbstractKismetObject(String className, String archetypeName, String[] inputLinkNames, String[] outputLinkNames, String[] variableLinkNames) {
        super(className, archetypeName);
        this.init(inputLinkNames, outputLinkNames, variableLinkNames);
    }

    public AbstractKismetObject(String className, UnrealReference archetype, String[] inputLinkNames, String[] outputLinkNames, String[] variableLinkNames) {
        super(className, archetype);
        this.init(inputLinkNames, outputLinkNames, variableLinkNames);
    }

    private void init(String[] inputLinkNames, String[] outputLinkNames, String[] variableLinkNames) {
        int i;
        this.inputLinks = new ArrayList<KismetInputLink>(inputLinkNames.length);
        for (i = 0; i < inputLinkNames.length; ++i) {
            this.inputLinks.add(new KismetInputLink(null));
            this.addInputLinkMapping(inputLinkNames[i], i);
        }
        this.outputLinks = new ArrayList<KismetOutputLink>(outputLinkNames.length);
        for (i = 0; i < outputLinkNames.length; ++i) {
            this.outputLinks.add(new KismetOutputLink(new ArrayList<KismetLinkTarget>()));
            this.addOutputLinkMapping(outputLinkNames[i], i);
        }
        this.variableLinks = new ArrayList<KismetVariableLink>(variableLinkNames.length);
        for (i = 0; i < variableLinkNames.length; ++i) {
            this.variableLinks.add(new KismetVariableLink(new ArrayList<UnrealReference>()));
            this.addVariableLinkMapping(variableLinkNames[i], i);
        }
    }

    private void addInputLinkMapping(String linkName, int linkIndex) {
        if (linkIndex >= this.inputLinks.size()) {
            throw new IndexOutOfBoundsException("Link " + linkIndex + " not found");
        }
        this.inputLinksMapping.put(linkName, linkIndex);
    }

    private void addOutputLinkMapping(String linkName, int linkIndex) {
        if (linkIndex >= this.outputLinks.size()) {
            throw new IndexOutOfBoundsException("Link " + linkIndex + " not found");
        }
        this.outputLinksMapping.put(linkName, linkIndex);
    }

    private void addVariableLinkMapping(String linkName, int linkIndex) {
        if (linkIndex >= this.variableLinks.size()) {
            throw new IndexOutOfBoundsException("Link " + linkIndex + " not found");
        }
        this.variableLinksMapping.put(linkName, linkIndex);
    }

    protected void addVariableLink(String name) {
        int linkIndex = this.variableLinks.size();
        this.variableLinks.add(new KismetVariableLink(new ArrayList<UnrealReference>()));
        this.addVariableLinkMapping(name, linkIndex);
    }

    public void setInputLinkMappingByNamesList(String[] linkNames) {
        for (int i = 0; i < linkNames.length; ++i) {
            this.addInputLinkMapping(linkNames[i], i);
        }
    }

    public void setOutputLinkMappingByNamesList(String[] linkNames) {
        for (int i = 0; i < linkNames.length; ++i) {
            this.addOutputLinkMapping(linkNames[i], i);
        }
    }

    public void setVariableLinkMappingByNamesList(String[] linkNames) {
        for (int i = 0; i < linkNames.length; ++i) {
            this.addVariableLinkMapping(linkNames[i], i);
        }
    }

    public void setInputLink(String linkName, KismetInputLink link) {
        if (link == null) {
            throw new NullPointerException("Link cannot be set to null");
        }
        Integer linkIndex = this.inputLinksMapping.get(linkName);
        if (linkIndex == null) {
            throw new IllegalArgumentException("Mapping for input link '" + linkName + "' not found.");
        }
        this.inputLinks.set(linkIndex, link);
    }

    public int getInputLinkIndex(String linkName) {
        return this.inputLinksMapping.get(linkName);
    }

    public KismetInputLink getInputLink(String linkName) {
        Integer linkIndex = this.inputLinksMapping.get(linkName);
        if (linkIndex == null) {
            throw new IllegalArgumentException("Mapping for input link '" + linkName + "' not found.");
        }
        return this.inputLinks.get(linkIndex);
    }

    public void setIntputLinkTarget(String linkName, UnrealReference target) {
        this.getInputLink(linkName).setTarget(target);
    }

    public void setOutputLink(String linkName, KismetOutputLink link) {
        if (link == null) {
            throw new NullPointerException("Link cannot be set to null");
        }
        Integer linkIndex = this.outputLinksMapping.get(linkName);
        if (linkIndex == null) {
            throw new IllegalArgumentException("Mapping for output link '" + linkName + "' not found.");
        }
        this.outputLinks.set(linkIndex, link);
    }

    public KismetOutputLink getOutputLink(String linkName) {
        Integer linkIndex = this.outputLinksMapping.get(linkName);
        if (linkIndex == null) {
            throw new IllegalArgumentException("Mapping for output link '" + linkName + "' not found.");
        }
        return this.outputLinks.get(linkIndex);
    }

    public void addOutputLinkTarget(String linkName, KismetLinkTarget target) {
        this.getOutputLink(linkName).addLink(target);
    }

    public void setVariableLink(String linkName, KismetVariableLink link) {
        if (link == null) {
            throw new NullPointerException("Link cannot be set to null");
        }
        Integer linkIndex = this.variableLinksMapping.get(linkName);
        if (linkIndex == null) {
            throw new IllegalArgumentException("Mapping for variable link '" + linkName + "' not found.");
        }
        this.variableLinks.set(linkIndex, link);
    }

    public void addVariableLinkTarget(String linkName, UnrealReference target) {
        this.getVariableLink(linkName).addLinkedVariable(target);
    }

    public KismetVariableLink getVariableLink(String linkName) {
        Integer linkIndex = this.variableLinksMapping.get(linkName);
        if (linkIndex == null) {
            throw new IllegalArgumentException("Mapping for variable link '" + linkName + "' not found.");
        }
        return this.variableLinks.get(linkIndex);
    }

    public Integer getInstanceVersion() {
        return this.instanceVersion;
    }

    public void setInstanceVersion(Integer instanceVersion) {
        this.instanceVersion = instanceVersion;
    }

    public String getObjComment() {
        return this.objComment;
    }

    public void setObjComment(String objComment) {
        this.objComment = objComment;
    }

    public Integer getObjPosX() {
        return this.objPosX;
    }

    public void setObjPosX(Integer objPosX) {
        this.objPosX = objPosX;
    }

    public Integer getObjPosY() {
        return this.objPosY;
    }

    public void setObjPosY(Integer objPosY) {
        this.objPosY = objPosY;
    }

    public Boolean getOutputObjCommentToScreen() {
        return this.outputObjCommentToScreen;
    }

    public void setOutputObjCommentToScreen(Boolean outputObjCommentToScreen) {
        this.outputObjCommentToScreen = outputObjCommentToScreen;
    }

    public Sequence getParentSequence() {
        return this.parentSequence;
    }

    public void setParentSequence(Sequence parentSequence) {
        this.parentSequence = parentSequence;
    }

    public Boolean getSuppressAutoComment() {
        return this.suppressAutoComment;
    }

    public void setSuppressAutoComment(Boolean suppressAutoComment) {
        this.suppressAutoComment = suppressAutoComment;
    }

    public List<KismetInputLink> getInputLinks() {
        return this.inputLinks;
    }

    public List<KismetOutputLink> getOutputLinks() {
        return this.outputLinks;
    }

    public List<KismetVariableLink> getVariableLinks() {
        return this.variableLinks;
    }

    public void setPositionForGUI(int x, int y) {
        this.setObjPosX(x);
        this.setObjPosY(y);
    }
}

