/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.UnrealDataType;

/**
 *
 * @author Martin Cerny
 */
@UnrealDataType
public class Point3D {
    float x;
    float y;
    float z;

    public Point3D(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }



    public float getX() {
        return x;
    }

    public float getY() {
        return y;
    }

    public float getZ() {
        return z;
    }

    public Point3D multiply(float a){
        return new Point3D(x * a, y * a, z * a);
    }

    public Point3D add(Point3D p){
        return new Point3D(x + p.getX(), y + p.getY(), z + p.getZ());
    }

    public Point3D negateX(){
        return new Point3D(-getX(), getY(),getZ());
    }
    public Point3D negateY(){
        return new Point3D(getX(), -getY(),getZ());
    }
    
    public Point3D negateXandY(){
        return new Point3D(-getX(), -getY(),getZ());
    }
    
    public Point3D switchXandY(){
        return new Point3D(getY(), getX(), getZ());                
    }
    
    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Point3D other = (Point3D) obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        if (Float.floatToIntBits(this.z) != Float.floatToIntBits(other.z)) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + Float.floatToIntBits(this.x);
        hash = 31 * hash + Float.floatToIntBits(this.y);
        hash = 31 * hash + Float.floatToIntBits(this.z);
        return hash;
    }

    @Override
    public String toString() {
        return "Point3D{" + "x=" + x + "y=" + y + "z=" + z + '}';
    }


}
