/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.map;

import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.UnrealComponent;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.annotations.UnrealProperty;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.datatypes.Point3D;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.elements.AbstractUnrealActor;

/**
 *
 * @author Martin Cerny
 * @see http://wiki.beyondunreal.com/UE3:StaticMeshActor_(UDK)
 */
public class StaticMeshActor extends AbstractUnrealActor {
    /**
     * Class name in unreal
     */
    public static final String CLASSNAME = "StaticMeshActor";

    @UnrealProperty
    @UnrealComponent
    private StaticMeshComponent staticMeshComponent;

    public StaticMeshActor(String meshName, Point3D location){
        this(new StaticMeshComponent(meshName),location);
    }
    
    public StaticMeshActor(StaticMeshComponent meshComponent, Point3D location) {
        super(CLASSNAME);
        init(location, meshComponent);
    }

    
    public StaticMeshActor(String archetypeName, StaticMeshComponent meshComponent, Point3D location) {
        super(CLASSNAME, archetypeName);
        init(location, meshComponent);
    }

    private void init(Point3D location, StaticMeshComponent meshComponent) {
        setLocation(location);
        staticMeshComponent = meshComponent;
        setCollisionComponent(meshComponent);
    }

    public StaticMeshComponent getStaticMeshComponent() {
        return staticMeshComponent;
    }



}
