/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunResult;
import cz.cuni.amis.pogamut.udk.experiments.IResultWriter;
import cz.cuni.amis.pogamut.udk.experiments.IValueConverter;
import cz.cuni.amis.pogamut.udk.experiments.impl.DefaultValueConverter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public abstract class AbstractCSVResultWriter<RESULT, EXPERIMENT_PARAMS>
implements IResultWriter<RESULT, EXPERIMENT_PARAMS> {
    private File targetFile;
    private FileWriter writer;
    protected String fieldDelimiter = ";";
    protected String lineDelimiter = "\r\n";
    protected String quote = "\"";
    private int numResultColumns;
    private IValueConverter valueConverter;
    private boolean writtenSomethingOnCurrentLine = false;

    public AbstractCSVResultWriter(File targetFile) {
        this(targetFile, new DefaultValueConverter());
    }

    public AbstractCSVResultWriter(File targetFile, IValueConverter valueConverter) {
        this.targetFile = targetFile;
        this.valueConverter = valueConverter;
    }

    protected abstract List<String> getParametersHeaders();

    protected abstract List<String> getResultHeaders();

    protected abstract List<Object> getParametersValues(EXPERIMENT_PARAMS var1);

    protected abstract List<Object> getResultValues(RESULT var1);

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    protected void writeField(String value) throws IOException {
        if (this.writtenSomethingOnCurrentLine) {
            this.writer.write(this.fieldDelimiter);
        } else {
            this.writtenSomethingOnCurrentLine = true;
        }
        this.writer.append(this.quote).append(value.replace(this.quote, this.quote + this.quote)).append(this.quote);
    }

    protected void endLine() throws IOException {
        this.writer.write(this.lineDelimiter);
        this.writer.flush();
        this.writtenSomethingOnCurrentLine = false;
    }

    @Override
    public void init() throws IOException {
        this.writer = new FileWriter(this.targetFile);
        this.writeField("#");
        this.writeField("Start time");
        for (String header : this.getParametersHeaders()) {
            this.writeField(header);
        }
        this.writeField("Status");
        this.writeField("Running time");
        List<String> resultHeaders = this.getResultHeaders();
        this.numResultColumns = resultHeaders.size();
        for (String header : resultHeaders) {
            this.writeField(header);
        }
        this.endLine();
    }

    @Override
    public void writeResult(int experimentNumber, IExperimentRunResult<RESULT> result, EXPERIMENT_PARAMS experimentParams) throws IOException {
        this.writeField(this.valueConverter.valueToString(experimentNumber));
        this.writeField(this.valueConverter.valueToString(new Date(result.getStartTime())));
        if (experimentParams != null) {
            for (Object field : this.getParametersValues(experimentParams)) {
                this.writeField(this.valueConverter.valueToString(field));
            }
        }
        this.writeField(result.getState().toString());
        this.writeField(this.valueConverter.valueToString(result.getRunningTime()));
        if (result.getState() == IExperimentRunResult.State.SUCCESS) {
            for (Object field : this.getResultValues(result.getResult())) {
                this.writeField(this.valueConverter.valueToString(field));
            }
        } else {
            for (int i = 0; i < this.numResultColumns; ++i) {
                this.writeField("");
            }
        }
        this.endLine();
    }
}

