/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments.utils;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopped;
import cz.cuni.amis.pogamut.base.agent.state.level3.IAgentStateResumed;
import cz.cuni.amis.pogamut.base.agent.state.level3.IAgentStateStartedPaused;
import cz.cuni.amis.utils.flag.FlagListener;


/**
 * Helper class that allows watching basic states of an agent
 * @author Martin Cerny
 */
public class WatchAgent {

    private IAgent agent;

    private IAgentState lastState;

    private boolean isWatching = false;

    private IWatchAgentCallback callback;

    private FlagListener<IAgentState> listener = new FlagListener<IAgentState>() {

        @Override
        public void flagChanged(IAgentState state) {
            if (state instanceof IAgentStateStartedPaused) {
                if (!(lastState instanceof IAgentStateStartedPaused)) {
                    callback.agentStartedPaused(agent);
                }
            } else if (state instanceof IAgentStateRunning) {
                if (!(lastState instanceof IAgentStateRunning)) {
                    callback.agentStarted(agent);
                }
            }
            if (state instanceof IAgentStateResumed) {
                if (!(lastState instanceof IAgentStateResumed)) {
                    callback.agentResumed(agent);
                }
            }
            if (state instanceof IAgentStateStopped) {
                if (!(lastState instanceof IAgentStateStopped)) {
                    callback.agentStopped(agent);
                }
            }
            if (state instanceof IAgentStateFailed) {
                if (!(lastState instanceof IAgentStateFailed)) {
                    callback.agentKilled(agent);
                }
            }

            lastState = state;
        }
    };

    public WatchAgent(IAgent agent, IWatchAgentCallback callback) {
        this.agent = agent;
        lastState = agent.getState().getFlag();
        this.callback = callback;
    }

    /**
     * Start watching the agent.
     */
    public synchronized void startWatching() {
        if (isWatching) {
            return;
        }
        agent.getState().addListener(listener);
        isWatching = true;
    }

    /**
     * Stop watching the agent.
     */
    public synchronized void stopWatching() {
        if (!isWatching) {
            return;
        }
        agent.getState().removeListener(listener);
        isWatching = false;
    }
}
