/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.udk.experiments.IValueConverter;
import java.util.Collection;

/**
 * Converter that uses toString to convert values and handles null values correctly. If the object
 * is a collection, result is concatenated toString values of children
 * @author Martin Cerny
 */
public class DefaultValueConverter implements IValueConverter{

    @Override
    public String valueToString(Object value) {
        if(value == null){
            return "N/A";
        }
        else if(value instanceof Class){
            return ((Class)value).getSimpleName();
        }
        else if(value instanceof Collection){
            StringBuilder stringValue = new StringBuilder("[");
            boolean first = true;
            for(Object o : (Collection)value){
                if(!first){
                    stringValue.append(", ");                            
                }
                first = false;
                stringValue.append(valueToString(o));
            }
            return stringValue.toString();
        } else {
            return value.toString();
        }
    }
    
}
