/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments;

/**
 * Interface for any object that measures time spent in various tasks
 * @author Martin Cerny
 */
public interface ITimeConsumedMeasuring<IDENTIFIER> {
    /**
     * Signal that a task has stareted
     * @param identifier 
     */
    public void taskStarted(IDENTIFIER identifier);
    public void taskFinished(IDENTIFIER identifier);
    
    /**
     * Explicitly add consumed time
     * @param identifier
     * @param milis 
     */
    public void taskConsumedTime(IDENTIFIER identifier, long milis);
    
    /**
     * Get time consumed so far (might not include unfinished task runs)
     * @param identifier
     * @return 
     */
    public long getConsumedTime(IDENTIFIER identifier);
    
    /**
     * Forces an end to all running tasks. Useful when forcibly terminating a measurement run
     */
    public void finishAllTasks();
    
}
