/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments;


import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import cz.cuni.amis.utils.flag.Flag;


/**
 * Interface that represents an experiment. An experiment is an object intended for single use. Reuse of the same experiment
 * for multiple runs may fail.
 * @author Martin Cerny
 */
public interface IExperiment<RESULT, PARAMETERS> {
    
    void setLog(LogCategory log);
    
    
    /**
     * Get the map name.
     * @return 
     */
    String getMapName();
       
    /**
     * Do some processing after the server has started
     * @param ucc
     * @param server 
     */
    void setServer(UCCWrapper ucc);
    
    /**
     * Start the experiment (ie. run bots, setup observers, ...)
     */
    void startExperiment();
    
    /**
     * <p>Cleanup after the experiment. Is called whenever the experiment ends due to:
     * </p>     
     * <ol>
     * <li>finished flag is set to true
     * </li>
     * <li>any method of this class throws an exception
     * </li>
     * <li>the server fails to start / fails to travel to specified map
     * </li>
     * </ol>
     * The cleanup method should release all resources already allocated and should
     * not fail in any of the cases mentioned above.
     */
    void cleanup();
    
    Flag<Boolean> getFinished();
    
    /**
     * Whether the experiment succeeded ie. it has yielded a result.
     * Note that in this sense agent failing to achieve a goal still in most cases means successful experiment (we have data).
     * Experiment failure in this sense is caused by an exception, component failing to start, misconfiguration etc.
     * @return 
     */
    boolean isSuccess();
    
    /**
     * Return the result, if any. If {@link #isSucces()} returns true, this funciton
     * must return non-null value.
     * @return 
     */
    RESULT getResult();
    
    PARAMETERS getParameters();
    
    /**
     * Short description of the experiment for logging purposes
     * @return 
     */
    public String getDescription();
}
