/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.udk.experiments.IValueConverter;
import cz.cuni.amis.pogamut.udk.experiments.impl.AbstractCSVResultWriter;
import cz.cuni.amis.pogamut.unreal.t3dgenerator.ReflectionUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class ReflectionCSVResultWriter<RESULT, EXPERIMENT_PARAMS>
extends AbstractCSVResultWriter<RESULT, EXPERIMENT_PARAMS> {
    List<Field> parametersFields;
    List<Field> resultFields;

    public ReflectionCSVResultWriter(File targetFile, IValueConverter valueConverter, Class<RESULT> resultClass, Class<EXPERIMENT_PARAMS> paramsClass) {
        super(targetFile, valueConverter);
        this.initFields(resultClass, paramsClass);
    }

    public ReflectionCSVResultWriter(File targetFile, Class<RESULT> resultClass, Class<EXPERIMENT_PARAMS> paramsClass) {
        super(targetFile);
        this.initFields(resultClass, paramsClass);
    }

    private void initFields(Class<RESULT> resultClass, Class<EXPERIMENT_PARAMS> paramsClass) {
        this.parametersFields = new ArrayList<Field>();
        this.resultFields = new ArrayList<Field>();
        ReflectionUtils.processEachDeclaredFieldOfClass(resultClass, (ReflectionUtils.ProcessFieldCallback)new ReflectionUtils.ProcessFieldCallback<RuntimeException>(){

            public void processField(Field f) throws RuntimeException {
                if (Modifier.isTransient(f.getModifiers()) || Modifier.isVolatile(f.getModifiers())) {
                    return;
                }
                f.setAccessible(true);
                ReflectionCSVResultWriter.this.resultFields.add(f);
            }
        });
        if (paramsClass != null) {
            ReflectionUtils.processEachDeclaredFieldOfClass(paramsClass, (ReflectionUtils.ProcessFieldCallback)new ReflectionUtils.ProcessFieldCallback<RuntimeException>(){

                public void processField(Field f) throws RuntimeException {
                    if (Modifier.isTransient(f.getModifiers()) || Modifier.isVolatile(f.getModifiers())) {
                        return;
                    }
                    f.setAccessible(true);
                    ReflectionCSVResultWriter.this.parametersFields.add(f);
                }
            });
        }
    }

    @Override
    protected List<String> getParametersHeaders() {
        ArrayList<String> headers = new ArrayList<String>(this.parametersFields.size());
        for (Field f : this.parametersFields) {
            headers.add(f.getName());
        }
        return headers;
    }

    @Override
    protected List<Object> getParametersValues(EXPERIMENT_PARAMS params) {
        ArrayList<Object> values = new ArrayList<Object>(this.parametersFields.size());
        for (Field f : this.parametersFields) {
            try {
                values.add(f.get(params));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalStateException("Error reading field " + f);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Error reading field " + f);
            }
        }
        return values;
    }

    @Override
    protected List<String> getResultHeaders() {
        ArrayList<String> headers = new ArrayList<String>(this.resultFields.size());
        for (Field f : this.resultFields) {
            headers.add(f.getName());
        }
        return headers;
    }

    @Override
    protected List<Object> getResultValues(RESULT result) {
        ArrayList<Object> values = new ArrayList<Object>(this.resultFields.size());
        for (Field f : this.resultFields) {
            try {
                values.add(f.get(result));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalStateException("Error reading field " + f);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Error reading field " + f);
            }
        }
        return values;
    }
}

