/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.StopRecord;
import cz.cuni.amis.pogamut.udk.experiments.IExperiment;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunResult;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunner;
import cz.cuni.amis.pogamut.udk.experiments.impl.ExperimentRunResult;
import cz.cuni.amis.pogamut.udk.factory.direct.remoteagent.UDKServerFactory;
import cz.cuni.amis.pogamut.udk.server.IUDKServer;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import cz.cuni.amis.pogamut.udk.utils.UDKServerRunner;

public class ExperimentRunner<RESULT, PARAMETERS>
implements IExperimentRunner<RESULT, PARAMETERS> {
    protected LogCategory log;
    private long timeout;

    public ExperimentRunner(LogCategory log, long timeout) {
        this.log = log;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExperimentRunResult<RESULT> runExperiment(IExperiment<RESULT, PARAMETERS> experiment) {
        long startTime = System.currentTimeMillis();
        experiment.setLog(this.log);
        UCCWrapper uccWrapper = null;
        IUDKServer server = null;
        String experimentDescription = experiment.getDescription();
        try {
            this.log.info("ExperimentRunner: Running experiment " + experimentDescription);
            this.log.info("ExperimentRunner: Performing beforeServerStart()");
            experiment.beforeServerStart();
            this.log.info("ExperimentRunner: Starting server.");
            UCCWrapper.UCCWrapperConf wrapperConfiguration = experiment.getUCCWrapperConfiguration();
            uccWrapper = new UCCWrapper(wrapperConfiguration);
            UDKServerFactory serverFactory = new UDKServerFactory();
            UDKServerRunner serverRunner = new UDKServerRunner((IAgentFactory)serverFactory, "UDKServerRunner", uccWrapper.getHost(), uccWrapper.getControlPort());
            server = serverRunner.startAgent();
            this.log.info("ExperimentRunner: Waiting for 1 sec to give UDKServer some time to catch up...");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.log.info("ExperimentRunner: Server started.");
            experiment.serverStarted(uccWrapper, server);
            experiment.startExperiment();
            experiment.getFinished().waitFor(this.timeout, (Object[])new Boolean[]{Boolean.TRUE});
            long runningTime = System.currentTimeMillis() - startTime;
            if (!((Boolean)experiment.getFinished().getFlag()).booleanValue()) {
                this.log.info("ExperimentRunner:  Experiment timed out");
                ExperimentRunResult experimentRunResult = ExperimentRunResult.timeout(runningTime);
                return experimentRunResult;
            }
            if (experiment.isSuccess()) {
                this.log.info("ExperimentRunner:  Experiment success");
                ExperimentRunResult<RESULT> experimentRunResult = ExperimentRunResult.succes(experiment.getResult(), runningTime);
                return experimentRunResult;
            }
            this.log.info("ExperimentRunner:  Experiment failed");
            ExperimentRunResult experimentRunResult = ExperimentRunResult.failure("Failed.", runningTime);
            return experimentRunResult;
        }
        catch (Exception ex) {
            long runningTime = System.currentTimeMillis() - startTime;
            ExperimentRunResult experimentRunResult = ExperimentRunResult.exception(ex, runningTime);
            return experimentRunResult;
        }
        finally {
            experiment.cleanup();
            if (server != null) {
                try {
                    server.getAct().act((CommandMessage)new StopRecord());
                }
                catch (Exception e) {
                    this.log.severe("Failed to stop recording." + e);
                }
                server.kill();
            }
            if (uccWrapper != null) {
                try {
                    uccWrapper.stop();
                }
                catch (Exception ex) {
                    this.log.severe("Failed to stop UCC." + ex);
                }
            }
        }
    }
}

