/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.experiments.IExperiment;
import cz.cuni.amis.pogamut.udk.server.IUDKServer;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import cz.cuni.amis.utils.flag.Flag;

public abstract class AbstractExperiment<RESULT, PARAMETERS>
implements IExperiment<RESULT, PARAMETERS> {
    private Flag<Boolean> finished = new Flag((Object)false);
    private RESULT result = null;
    private PARAMETERS parameters;
    private boolean succes = false;
    protected LogCategory log;
    protected UCCWrapper ucc;
    protected IUDKServer udkServer;

    public AbstractExperiment(PARAMETERS parameters) {
        this.parameters = parameters;
    }

    @Override
    public void beforeServerStart() {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public Flag<Boolean> getFinished() {
        return this.finished;
    }

    @Override
    public final RESULT getResult() {
        return this.result;
    }

    @Override
    public PARAMETERS getParameters() {
        return this.parameters;
    }

    protected void succeed(RESULT result) {
        if (result == null) {
            throw new NullPointerException("Result can't be set to null.");
        }
        this.result = result;
        this.succes = true;
        this.finished.setFlag((Object)true);
    }

    @Override
    public UCCWrapper.UCCWrapperConf getUCCWrapperConfiguration() {
        return new UCCWrapper.UCCWrapperConf().setStartOnUnusedPort(true);
    }

    @Override
    public void serverStarted(UCCWrapper ucc, IUDKServer server) {
        this.ucc = ucc;
        this.udkServer = server;
    }

    @Override
    public void setLog(LogCategory log) {
        this.log = log;
    }

    @Override
    public void startExperiment() {
    }

    @Override
    public boolean isSuccess() {
        return this.succes;
    }

    protected void fail(String message, Exception e) {
        String messageToLog = message != null ? "Experiment failed." : "Experiment failed: " + message;
        if (e != null) {
            this.log.severe(messageToLog, (Object)e);
        } else {
            this.log.severe(messageToLog);
        }
        this.succes = false;
        this.finished.setFlag((Object)true);
    }

    protected void fail(String message) {
        this.fail(message, null);
    }

    protected void fail(Exception ex) {
        this.fail(null, ex);
    }

    protected void fail() {
        this.fail(null, null);
    }
}

