/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentDescriptor;
import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.MultipleAgentRunner;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.udk.agent.params.UDKAgentParameters;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.experiments.impl.AbstractExperiment;
import cz.cuni.amis.pogamut.udk.experiments.utils.WatchAgent;
import cz.cuni.amis.pogamut.udk.experiments.utils.WatchAgentCallbackAdapter;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKBotFactory;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKBotModule;
import java.util.ArrayList;
import java.util.List;

public class AbstractBotExperiment<RESULT, PARAMETERS>
extends AbstractExperiment<RESULT, PARAMETERS> {
    protected IAgentDescriptor<UDKAgentParameters, UDKBotModule>[] agentDescriptors;
    protected List<UDKBot> runningBots = new ArrayList<UDKBot>();
    protected List<WatchAgent> watchAgents = new ArrayList<WatchAgent>();
    boolean failIfBotKilled;

    public AbstractBotExperiment(boolean failIfBotKilled, PARAMETERS params, IAgentDescriptor<UDKAgentParameters, UDKBotModule> ... bots) {
        super(params);
        this.agentDescriptors = bots;
        this.failIfBotKilled = failIfBotKilled;
    }

    public AbstractBotExperiment(PARAMETERS params, IAgentDescriptor<UDKAgentParameters, UDKBotModule> ... bots) {
        this(false, params, bots);
    }

    protected void startBots(IAgentDescriptor<UDKAgentParameters, UDKBotModule>[] bots) {
        AgentRunner runner = new AgentRunner();
        try {
            runner.startAgents(bots);
        }
        catch (Exception ex) {
            this.fail("Bot start failed", ex);
        }
    }

    @Override
    public final void startExperiment() {
        this.startBots(this.agentDescriptors);
        this.afterBotsStarted();
    }

    protected void afterBotsStarted() {
    }

    @Override
    public void cleanup() {
        for (WatchAgent watch : this.watchAgents) {
            watch.stopWatching();
        }
        for (UDKBot bot : this.runningBots) {
            bot.kill();
        }
    }

    private class AgentRunner
    extends MultipleAgentRunner<UDKBot, UDKAgentParameters, UDKBotModule> {
        private AgentRunner() {
        }

        protected IAgentFactory newAgentFactory(UDKBotModule agentModule) {
            return new UDKBotFactory(agentModule);
        }

        protected IAgentParameters newDefaultAgentParameters() {
            return new UDKAgentParameters().setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(AbstractBotExperiment.this.ucc.getHost(), AbstractBotExperiment.this.ucc.getBotPort())).setAgentId((IAgentId)new AgentId("Agent"));
        }

        protected void postStartedHook(List<UDKBot> agents) {
            super.postStartedHook(agents);
            MonitorAgentAliveCallback monitorAliveCallback = new MonitorAgentAliveCallback();
            AbstractBotExperiment.this.runningBots.addAll(agents);
            for (UDKBot bot : agents) {
                WatchAgent watchAgent = new WatchAgent((IAgent)bot, monitorAliveCallback);
                watchAgent.startWatching();
                AbstractBotExperiment.this.watchAgents.add(watchAgent);
            }
        }
    }

    private class MonitorAgentAliveCallback
    extends WatchAgentCallbackAdapter {
        private MonitorAgentAliveCallback() {
        }

        @Override
        public void agentKilled(IAgent agent) {
            if (AbstractBotExperiment.this.failIfBotKilled) {
                AbstractBotExperiment.this.fail("Bot " + agent.getName() + " killed.");
            }
        }

        @Override
        public void agentStopped(IAgent agent) {
            AbstractBotExperiment.this.fail("Bot " + agent.getName() + " stopped.");
        }
    }
}

