/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments.utils;

import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.AgentDescriptor;
import cz.cuni.amis.pogamut.udk.agent.params.UDKAgentParameters;
import cz.cuni.amis.pogamut.udk.bot.IUDKBotController;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKBotModule;

/**
 * Helper class for quickly instantiating descriptors of UDK bots
 * @author Martin Cerny
 */
public class UDKBotAgentDescriptor extends AgentDescriptor<UDKAgentParameters, UDKBotModule> {

    /**
     * Create an empty descriptor
     */
    public UDKBotAgentDescriptor() {
    }
        
    
    /**
     * Create a descriptor that creates a single agent with specified module
     * @param module 
     */
    public UDKBotAgentDescriptor(UDKBotModule module){        
        setAgentModule(module);
        setCount(1);
    }
    
    /**
     * Create a descriptor that creates a single agent with default UDKBotModule for specified class.
     * @param module 
     */
    public UDKBotAgentDescriptor(Class<? extends IUDKBotController> botControllerClass){        
        setAgentModule(new UDKBotModule(botControllerClass));
        setCount(1);
    }
    
    /**
     * Create a descriptor that creates a single agent with default UDKBotModule for specified class and with specified parameters
     * @param module 
     */
    public UDKBotAgentDescriptor(Class<? extends IUDKBotController> botControllerClass, UDKAgentParameters params){        
        this(botControllerClass);
        setAgentParameters(new UDKAgentParameters[] {params});
    }
    
}
