/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments.impl;

import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunResult;
import cz.cuni.amis.pogamut.udk.experiments.IExperimentRunResult.State;

/**
 *
 * @author Martin Cerny
 */
public class ExperimentRunResult<RESULT> implements IExperimentRunResult<RESULT> {
    private State state;
    private RESULT result;
    private Exception exception ;
    private String message;
    private long runningTime;

    private ExperimentRunResult(State state, RESULT result, Exception exception, String message, long runningTime) {
        this.state = state;
        this.result = result;
        this.exception = exception;
        this.message = message;
        this.runningTime = runningTime;
    }
 

    @Override public Exception getException() {
        return exception;
    }

    @Override public String getMessage() {
        return message;
    }

    @Override public RESULT getResult() {
        return result;
    }

    @Override public State getState() {
        return state;
    }

    @Override public long getRunningTime() {
        return runningTime;
    }
    
    
    
    
    public static <RESULT> ExperimentRunResult<RESULT> succes(RESULT result, long runningTime){
        return new ExperimentRunResult<RESULT>(State.SUCCESS, result, null, null, runningTime);
    }
    
    public static <RESULT> ExperimentRunResult<RESULT> timeout(long runningTime){
        return new ExperimentRunResult<RESULT>(State.TIMEOUT, null, null, null,runningTime);
    }

    public static <RESULT> ExperimentRunResult<RESULT> exception(Exception ex, long runningTime){
        return new ExperimentRunResult<RESULT>(State.EXCEPTION, null, ex, null, runningTime);
    }
    public static <RESULT> ExperimentRunResult<RESULT> failure(String message, long runningTime){
        return new ExperimentRunResult<RESULT>(State.FAILURE, null, null, message, runningTime);
    }
    
}
