/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.records;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.MapEvent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.pogamut.base.utils.logging.marks.LogMapMark;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MapEvents
implements Serializable {
    private TLEntity entity;
    private LinkedList<MapEvent> allEvents = new LinkedList();
    private LinkedList<MapEvent> unfinishedEvents = new LinkedList();

    public MapEvents(TLEntity entity) {
        this.entity = entity;
    }

    public List<MapEvent> getEvents(long time) {
        LinkedList<MapEvent> timeEvents = new LinkedList<MapEvent>();
        for (MapEvent event : this.allEvents) {
            if (!event.timeframeContains(time)) continue;
            timeEvents.add(event);
        }
        return timeEvents;
    }

    private LogMapMark hasMark(LogRecord record) {
        for (Object o : record.getParameters()) {
            if (!(o instanceof LogMapMark)) continue;
            return (LogMapMark)o;
        }
        return null;
    }

    void update(LogRecord record) {
        LogMapMark mark = this.hasMark(record);
        if (mark == null) {
            return;
        }
        System.out.println("ME: Got new mark");
        if (mark.getType() == LogMapMark.Type.FIXED_DURATION) {
            MapEvent newMapEvent = new MapEvent(this.entity, record, mark);
            this.allEvents.add(newMapEvent);
            return;
        }
        if (mark.getType() == LogMapMark.Type.END_EVENT) {
            MapEvent unfinished = this.getUnfinishedEventWithMark(mark);
            if (unfinished == null) {
                if (Logger.getLogger("global").isLoggable(Level.SEVERE)) {
                    Logger.getLogger("global").severe("Got end of map event, but no such event started. Possibly duplicated end.");
                }
                return;
            }
            this.finishEvent(unfinished, record);
            return;
        }
        if (mark.getType() == LogMapMark.Type.START_EVENT) {
            MapEvent newMapEvent = new MapEvent(this.entity, record, mark);
            this.unfinishedEvents.add(newMapEvent);
            this.allEvents.add(newMapEvent);
            return;
        }
        throw new RuntimeException("I should never got here. Type of event: " + mark.getType());
    }

    private MapEvent getUnfinishedEventWithMark(LogMapMark mark) {
        for (MapEvent mapEvent : this.unfinishedEvents) {
            if (mark.getId() != mapEvent.getMark().getId()) continue;
            return mapEvent;
        }
        return null;
    }

    private void finishEvent(MapEvent unfinished, LogRecord record) {
        unfinished.recievedClosingRecord(record);
        this.unfinishedEvents.remove(unfinished);
    }

    public List<MapEvent> getMapEvents() {
        return Collections.unmodifiableList(this.allEvents);
    }
}

