/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.map;

import cz.cuni.amis.nb.pogamut.unreal.map.SelectableMapGLPanel;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.IRenderableUTAgent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.MapRenderer;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.MapViewpoint;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.TLRenderableUTAgent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.UTAgentSubGLRenderer;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLDatabase;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMap;
import java.util.Set;
import java.util.logging.Logger;

public class TLMapGLPanel
extends SelectableMapGLPanel {
    private final TLDatabase database;
    private final TLDatabase.Adapter currentTimeListener = new TLDatabase.Adapter(){

        @Override
        public void currentTimeChanged(long previousCurrentTime, long currentTime) {
            TLMapGLPanel.this.updateEntityRenderers(currentTime);
            TLMapGLPanel.this.display();
        }
    };

    public TLMapGLPanel(IUnrealMap map, TLDatabase db) {
        super(map, Logger.getLogger("TLMapGLPanel"));
        this.database = db;
        db.addDBListener(this.currentTimeListener);
    }

    private synchronized void updateEntityRenderers(long time) {
        Set toBeRemoved = this.agentRenderes.getDrawnObjects();
        Set<TLEntity> toBeAdded = this.database.getEntities(time);
        for (IRenderableUTAgent renderableUTAgent : toBeRemoved) {
            this.agentRenderes.removeRenderersOf(renderableUTAgent);
        }
        for (TLEntity entity : toBeAdded) {
            TLRenderableUTAgent renderableUTAgent = new TLRenderableUTAgent(entity, time, this.lastGLName++);
            UTAgentSubGLRenderer renderer = new UTAgentSubGLRenderer(renderableUTAgent, this.getMap());
            this.agentRenderes.addSubRenderer(renderer);
        }
    }

    public MapViewpoint getMapViewpoint() {
        return this.mapViewpoint;
    }

    public MapRenderer getMapRenderer() {
        return this.mapRenderer;
    }
}

