/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.base.agent;

import cz.cuni.amis.nb.pogamut.base.agent.ControllableAgentNode;
import cz.cuni.amis.nb.util.PeriodicalyUpdatedProperty;
import cz.cuni.amis.pogamut.base3d.agent.IAgent3D;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public abstract class Agent3DNode<T extends IAgent3D>
extends ControllableAgentNode<T> {
    protected Collection<Node.Property> updatableProps = new LinkedList<Node.Property>();

    public Agent3DNode(T agent) {
        super(agent);
        this.addUpdateTask(new Runnable(){

            @Override
            public void run() {
                for (Node.Property prop : Agent3DNode.this.updatableProps) {
                    try {
                        Agent3DNode.this.firePropertyChange(prop.getName(), null, prop.getValue());
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                    catch (InvocationTargetException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set props = new Sheet.Set();
        props.setDisplayName("Agent3D");
        props.setName("Agent3D");
        sheet.put(props);
        try {
            Node.Property[] propArr = new Node.Property[]{new PeriodicalyUpdatedProperty<Location>(this.agent, "Location", Location.class, "Location", "Location of the agent."), new PeriodicalyUpdatedProperty<Rotation>(this.agent, "Rotation", Rotation.class, "Rotation", "Rotation of the agent."), new PeriodicalyUpdatedProperty<Velocity>(this.agent, "Velocity", Velocity.class, "Velocity", "Velocity of the agent.")};
            this.updatableProps.addAll(Arrays.asList(propArr));
            props.put(propArr);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sheet;
    }
}

