/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.base.server;

import cz.cuni.amis.nb.api.pogamut.base.server.ServerDefinition;
import cz.cuni.amis.nb.pogamut.base.NamedAction;
import cz.cuni.amis.nb.pogamut.base.server.ServerNode;
import cz.cuni.amis.nb.util.NodeFactory;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import javax.swing.Action;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public abstract class EmbededServerNode<T extends ServerDefinition>
extends ServerNode<T> {
    InputOutput serverIO = null;
    protected Flag<Boolean> serverRunning = new Flag((Object)false);

    public EmbededServerNode() {
        super(null, null, new NodeFactory<IAgent>(){

            @Override
            public Node[] create(IAgent obj) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
    }

    public abstract Reader getServerConsoleOutput();

    public InputOutput getServerIO() {
        return this.serverIO;
    }

    @Override
    public Action[] getActions(boolean context) {
        return new Action[]{new NamedAction("ACT_StartServer"){

            @Override
            public void action(ActionEvent e) throws PogamutException {
                EmbededServerNode.this.startServerInternal();
            }

            @Override
            public boolean isEnabled() {
                return (Boolean)EmbededServerNode.this.serverRunning.getFlag() == false;
            }
        }, new NamedAction("ACT_RestartServer"){

            @Override
            public void action(ActionEvent e) throws PogamutException {
                EmbededServerNode.this.restartServer();
            }

            @Override
            public boolean isEnabled() {
                return (Boolean)EmbededServerNode.this.serverRunning.getFlag();
            }
        }, new NamedAction("ACT_StopServer"){

            @Override
            public void action(ActionEvent e) throws PogamutException {
                EmbededServerNode.this.stopServerInternal();
            }

            @Override
            public boolean isEnabled() {
                return (Boolean)EmbededServerNode.this.serverRunning.getFlag();
            }
        }, null, new NamedAction("ACT_ShowServerOutput"){

            @Override
            protected void action(ActionEvent e) throws PogamutException {
                EmbededServerNode.this.getServerIO().select();
            }

            @Override
            public boolean isEnabled() {
                return EmbededServerNode.this.getServerIO() != null;
            }
        }};
    }

    protected void restartServer() throws PogamutException {
        this.stopServerInternal();
        this.startServerInternal();
    }

    protected abstract void startServer() throws PogamutException;

    protected abstract void stopServer() throws PogamutException;

    protected void startServerInternal() throws PogamutException {
        this.startServer();
        this.createServerOutput();
        this.getServerIO().select();
        this.serverRunning.setFlag((Object)true);
    }

    protected void stopServerInternal() throws PogamutException {
        this.stopServer();
        this.serverRunning.setFlag((Object)false);
    }

    protected void createServerOutput() {
        if (this.serverIO == null) {
            this.serverIO = IOProvider.getDefault().getIO("Server " + this.getDisplayName() + " console", true);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int ch;
                    while ((ch = EmbededServerNode.this.getServerConsoleOutput().read()) != -1) {
                        EmbededServerNode.this.serverIO.getOut().write(ch);
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }).start();
    }
}

