/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.base.logging;

import cz.cuni.amis.nb.pogamut.base.logging.LimitedQueue;
import cz.cuni.amis.nb.pogamut.base.logging.LogRecordListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public abstract class LogRecordsSource<T> {
    protected List<Filter<T>> filters = new ArrayList<Filter<T>>();
    protected Set<LogRecordListener> listeners = new HashSet<LogRecordListener>();
    protected LimitedQueue<LogRecord> queue = new LimitedQueue();
    RegexpFilter regexpFilter = new RegexpFilter(Pattern.compile(""));

    public LogRecordsSource() {
        this.filters.add(new Filter(){

            public boolean filter(Object t) {
                return true;
            }
        });
    }

    public void addLogRecordListener(LogRecordListener l) {
        this.listeners.add(l);
        this.notifySetNewData(l);
    }

    public void removeLogRecordListener(LogRecordListener l) {
        this.listeners.remove(l);
    }

    public void clear() {
        this.queue.clear();
        this.notifySetNewData();
    }

    protected void notifyLogRecordsListeners(LogRecord r) {
        for (LogRecordListener listener : this.listeners) {
            listener.notifyNewLogRecord(r);
        }
    }

    protected abstract LogRecord toLogRecord(T var1);

    public void notifySetNewData() {
        Collection<LogRecord> data = this.getFilteredData();
        for (LogRecordListener listener : this.listeners) {
            listener.setNewData(data);
        }
    }

    public void notifySetNewData(LogRecordListener listener) {
        listener.setNewData(this.getFilteredData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<LogRecord> getFilteredData() {
        ArrayList<LogRecord> list = new ArrayList<LogRecord>();
        LimitedQueue<LogRecord> limitedQueue = this.queue;
        synchronized (limitedQueue) {
            for (LogRecord lr : this.queue.getAll()) {
                T msg = this.getLogRecParam(lr);
                if (!this.filter(msg)) continue;
                list.add(lr);
            }
            return list;
        }
    }

    protected boolean filter(T msg) {
        for (Filter<T> f : this.filters) {
            if (f.filter(msg)) continue;
            return false;
        }
        return true;
    }

    public Filter<T> replaceFilter(Filter<T> oldFilter, Filter<T> newFilter) {
        this.removeFilter(oldFilter);
        this.addFilter(newFilter);
        return newFilter;
    }

    public void setRegexpFilterPatter(Pattern pattern) {
        if (pattern == null) {
            this.removeFilter(this.regexpFilter);
            this.regexpFilter = null;
        } else {
            this.regexpFilter = (RegexpFilter)this.replaceFilter(this.regexpFilter, new RegexpFilter(pattern));
        }
    }

    public void addFilter(Filter filter) {
        if (this.filters.add(filter)) {
            this.notifySetNewData();
        }
    }

    public void removeFilter(Filter filter) {
        if (this.filters.remove(filter)) {
            this.notifySetNewData();
        }
    }

    protected T getLogRecParam(LogRecord lr) {
        return (T)lr.getParameters()[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessage(T msg) {
        LogRecord lr = this.toLogRecord(msg);
        lr.setParameters(new Object[]{msg});
        LimitedQueue<LogRecord> limitedQueue = this.queue;
        synchronized (limitedQueue) {
            this.queue.add(lr);
        }
        if (this.filter(msg)) {
            this.notifyLogRecordsListeners(lr);
        }
    }

    public Sheet.Set getPropSet() {
        Sheet.Set props = Sheet.createPropertiesSet();
        final ResourceBundle bundle = NbBundle.getBundle(LogRecordsSource.class);
        class RegexpFilterProp
        extends PropertySupport.ReadWrite {
            public RegexpFilterProp() {
                super("regexpFilterProp", Pattern.class, resourceBundle.getString("PROP_RegexpFilter"), resourceBundle.getString("HINT_RegexpFilter"));
            }

            public Object getValue() {
                if (LogRecordsSource.this.regexpFilter == null) {
                    return null;
                }
                return LogRecordsSource.this.regexpFilter.pattern;
            }

            public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException {
                LogRecordsSource.this.setRegexpFilterPatter((Pattern)object);
            }
        }
        props.put((Node.Property)new RegexpFilterProp());
        return props;
    }

    public class RegexpFilter<T>
    implements Filter<T> {
        Pattern pattern = null;

        public RegexpFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean filter(T t) {
            return this.pattern.matcher(t.toString()).matches();
        }
    }

    public static interface Filter<T> {
        public boolean filter(T var1);
    }
}

