/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.util.editors;

import java.beans.PropertyEditorSupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URIEditorSupport
extends PropertyEditorSupport {
    String protocol;

    public URIEditorSupport() {
        this.protocol = "ut04";
    }

    public URIEditorSupport(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public String getAsText() {
        URI uri = (URI)this.getValue();
        if (uri != null) {
            return uri.toString();
        }
        return "[not set]";
    }

    @Override
    public void setAsText(String s) {
        try {
            if (s.equals("")) {
                this.setValue(null);
            } else {
                this.setValue(this.translateURI(s));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    protected URI translateURI(String uriStr) throws URISyntaxException {
        if (uriStr.isEmpty()) {
            return URI.create("");
        }
        Pattern p = Pattern.compile(".+://.*");
        Matcher m = p.matcher(uriStr);
        if (!m.matches()) {
            uriStr = this.protocol + "://" + uriStr;
        }
        if (!uriStr.matches(".+://.+:[0-9]+")) {
            uriStr = uriStr + ":3001";
        }
        return new URI(uriStr);
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }
}

