/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.base.project.template.utils;

import cz.cuni.amis.nb.pogamut.base.project.template.utils.ProjectCreationUtils;
import cz.cuni.amis.nb.pogamut.base.project.template.utils.TemplateBotProjectWizardPanel;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class TemplateBotProjectWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor wiz;

    public static TemplateBotProjectWizardIterator createIterator() {
        return new TemplateBotProjectWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new TemplateBotProjectWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(TemplateBotProjectWizardIterator.class, (String)"LBL_CreateProjectStep")};
    }

    public Set instantiate() throws IOException {
        ProjectCreationUtils.handleWizardDescriptor(this.wiz);
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        File dirF = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        dirF.mkdirs();
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject dir = FileUtil.toFileObject((File)dirF);
        ProjectCreationUtils.unZipFile(template.getInputStream(), dir);
        String projName = (String)this.wiz.getProperty("name");
        File sourceDir = new File(dirF, "");
        for (File file : sourceDir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".properties")) continue;
            ProjectCreationUtils.substituteInFile(file, Pattern.compile("javabottemplate"), projName.toLowerCase());
            ProjectCreationUtils.substituteInFile(file, Pattern.compile("JavaBotTemplate"), projName);
        }
        sourceDir = new File(dirF, "nbproject");
        for (File file : sourceDir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".properties")) continue;
            ProjectCreationUtils.substituteInFile(file, Pattern.compile("javabottemplate"), projName.toLowerCase());
            ProjectCreationUtils.substituteInFile(file, Pattern.compile("JavaBotTemplate"), projName);
        }
        sourceDir = new File(dirF, "src/javabottemplate");
        for (File file : sourceDir.listFiles()) {
            if (!file.getName().endsWith(".java")) continue;
            ProjectCreationUtils.substituteInFile(file, Pattern.compile("javabottemplate"), projName.toLowerCase());
            ProjectCreationUtils.substituteInFile(file, Pattern.compile("__PROJECT_NAME__"), projName);
            if (file.getName().equals("Main.java")) {
                ProjectCreationUtils.substituteInFile(file, Pattern.compile("MainClass"), projName);
                file.renameTo(new File(file.getParentFile().getAbsolutePath() + File.separator + projName + ".java"));
            }
            if (!file.getName().contains("MainClass")) continue;
            String subst = file.getName().replaceFirst("MainClass", projName);
            ProjectCreationUtils.substituteInFile(file, Pattern.compile("MainClass"), projName);
            file.renameTo(new File(file.getParentFile().getAbsolutePath() + File.separator + subst));
        }
        File rootPackage = new File(dirF, "src/javabottemplate");
        rootPackage.renameTo(new File(dirF, "src/" + projName.toLowerCase()));
        Pattern p = Pattern.compile("<name>JavaBotTemplate</name>");
        File projectXmlFile = new File(dirF, "nbproject/project.xml");
        String xmlStr = ProjectCreationUtils.loadFileToString(projectXmlFile);
        Matcher matcher = p.matcher(xmlStr);
        String newXmlStr = matcher.replaceAll("<name>" + projName + "</name>");
        projectXmlFile.delete();
        projectXmlFile.createNewFile();
        BufferedWriter outBuffer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(projectXmlFile)));
        outBuffer.write(newXmlStr, 0, newXmlStr.length());
        outBuffer.close();
        p = Pattern.compile("JavaBotTemplate");
        File buildXmlFile = new File(dirF, "./build.xml");
        xmlStr = ProjectCreationUtils.loadFileToString(buildXmlFile);
        matcher = p.matcher(xmlStr);
        newXmlStr = matcher.replaceAll(projName);
        buildXmlFile.delete();
        buildXmlFile.createNewFile();
        outBuffer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(buildXmlFile)));
        outBuffer.write(newXmlStr, 0, newXmlStr.length());
        outBuffer.close();
        resultSet.add(dir);
        Enumeration e = dir.getFolders(true);
        while (e.hasMoreElements()) {
            FileObject subfolder = (FileObject)e.nextElement();
            if (!ProjectManager.getDefault().isProject(subfolder)) continue;
            resultSet.add(subfolder);
        }
        File parent = dirF.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format("{0} of {1}", new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

