/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.base.logging;

import cz.cuni.amis.nb.pogamut.base.logging.LogNode;
import cz.cuni.amis.nb.pogamut.base.logging.LogTableModel;
import cz.cuni.amis.nb.pogamut.base.logging.LogViewerPane;
import java.awt.BorderLayout;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class LogViewerTopComponent
extends TopComponent {
    private static LogViewerTopComponent instance;
    private static final String PREFERRED_ID = "LogViewerTopComponent";
    protected LogNode logNode = null;
    protected Node currentNode = null;
    protected Lookup lkp = null;
    protected static Map<LogNode, LogViewerTopComponent> logToWin;
    private LogViewerPane logViewerPane1;

    protected LogViewerTopComponent(LogNode logNode) {
        this.initComponents();
        this.setToolTipText(NbBundle.getMessage(LogViewerTopComponent.class, (String)"HINT_LogViewerTopComponent"));
        this.setNodeToView(logNode);
        this.logNode = logNode;
    }

    public LogNode getLogNode() {
        return this.logNode;
    }

    protected void setNodeToView(LogNode logNode) {
        this.setName(logNode.getName());
        this.logViewerPane1.setLogNode(logNode);
        this.currentNode = logNode;
        this.lkp = logNode.getLookup();
    }

    public void componentActivated() {
        this.setActivatedNodes(new Node[]{this.currentNode});
        super.componentActivated();
    }

    public Lookup getLookup() {
        return this.lkp;
    }

    public static LogViewerTopComponent getWin(LogNode logNode) {
        if (!logToWin.containsKey((Object)logNode)) {
            LogViewerTopComponent logWin = new LogViewerTopComponent(logNode);
            logToWin.put(logNode, logWin);
            return logWin;
        }
        return logToWin.get((Object)logNode);
    }

    public LogViewerTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(LogViewerTopComponent.class, (String)"CTL_LogViewerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(LogViewerTopComponent.class, (String)"HINT_LogViewerTopComponent"));
    }

    private void initComponents() {
        this.logViewerPane1 = new LogViewerPane();
        this.setLayout(new BorderLayout());
        this.add(this.logViewerPane1, "Center");
    }

    public static synchronized LogViewerTopComponent getDefault() {
        if (instance == null) {
            instance = new LogViewerTopComponent();
        }
        return instance;
    }

    public static synchronized LogViewerTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find LogViewer component. It will not be located properly in the window system.");
            return LogViewerTopComponent.getDefault();
        }
        if (win instanceof LogViewerTopComponent) {
            return (LogViewerTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'LogViewerTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return LogViewerTopComponent.getDefault();
    }

    public LogTableModel getLogTableModel() {
        return this.logViewerPane1.getLogTableModel();
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static {
        logToWin = new HashMap<LogNode, LogViewerTopComponent>();
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return LogViewerTopComponent.getDefault();
        }
    }
}

