/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.bot.emohawkNavigation;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.bot.EmohawkBotTestController;
import cz.cuni.amis.pogamut.emohawk.bot.emohawkNavigation.NavigationTestBotParameters2;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

public class NavigationTestBot2
extends EmohawkBotTestController<UT2004Bot> {
    State state = State.INIT;
    NavPoint startNavPoint = null;
    NavPoint endNavPoint = null;
    UnrealId startNavPointId = null;
    UnrealId endNavPointId = null;
    Integer totalRepetitions = null;
    int repetitions = 0;
    boolean walkInCircles = false;
    String name;

    public void prepareBot(UT2004Bot bot) {
        if (bot.getParams() instanceof NavigationTestBotParameters2) {
            if (this.startNavPointId == null) {
                this.setStartNavPointId(((NavigationTestBotParameters2)bot.getParams()).getStartNavPointId());
            }
            if (this.endNavPointId == null) {
                this.setEndNavPointId(((NavigationTestBotParameters2)bot.getParams()).getEndNavPointId());
            }
            if (this.totalRepetitions == null) {
                this.totalRepetitions = ((NavigationTestBotParameters2)bot.getParams()).getNumOfRepetitions();
            }
            this.walkInCircles = ((NavigationTestBotParameters2)bot.getParams()).isWalkInCircles();
        }
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        super.botInitialized(gameInfo, currentConfig, init);
    }

    public void botFirstSpawn(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
        this.name = self.getName();
    }

    public void logic() {
        if (this.isFailure()) {
            this.log.severe("FAILED");
            return;
        }
        if (this.isSuccess()) {
            this.log.severe("SUCCEEDED");
            return;
        }
        switch (this.state) {
            case INIT: {
                if (this.startNavPointId == null) {
                    this.setFailure("startNavPointId not set!");
                    return;
                }
                if (this.endNavPointId == null) {
                    this.setFailure("endNavPointId not set!");
                }
                this.startNavPoint = (NavPoint)this.world.getAll(NavPoint.class).get(this.startNavPointId);
                if (this.startNavPoint == null) {
                    this.setFailure("Could not find start navpoint '" + this.startNavPointId.getStringId() + "'!");
                    return;
                }
                this.log.info("StartNavPoint: " + this.startNavPoint);
                this.endNavPoint = (NavPoint)this.world.getAll(NavPoint.class).get(this.endNavPointId);
                if (this.endNavPoint == null) {
                    this.setFailure("Could not find end navpoint '" + this.endNavPointId.getStringId() + "'!");
                    return;
                }
                this.log.info("EndNavPoint: " + this.endNavPoint);
                if (this.totalRepetitions == null) {
                    this.setFailure("Number of repetitions for the test was not set!");
                    return;
                }
                this.repetitions = this.totalRepetitions;
                if (this.repetitions <= 0) {
                    this.setFailure("Number of repetitions for the test <= 0!");
                    return;
                }
                this.bot.getAct().act((CommandMessage)new Respawn().setStartLocation(this.startNavPoint.getLocation()));
                this.state = State.PREPARE_TEST;
                return;
            }
            case PREPARE_TEST: {
                this.bot.getAct().act((CommandMessage)new Respawn().setStartLocation(this.startNavPoint.getLocation()));
                this.state = State.SPAWNED;
                return;
            }
            case SPAWNED: {
                if (!this.info.isAtLocation((ILocated)this.startNavPoint)) {
                    this.log.warning("Bot is not at " + this.startNavPoint.getId().getStringId() + ", respawning again!");
                    this.bot.getAct().act((CommandMessage)new Respawn().setStartLocation(this.startNavPoint.getLocation()));
                    return;
                }
                this.log.warning("Navigation test " + (this.totalRepetitions - this.repetitions + 1) + " / " + this.totalRepetitions);
                this.config.setName(this.name + " " + (this.totalRepetitions - this.repetitions + 1) + " / " + this.totalRepetitions);
                this.emohawkNavigation.navigate((ILocated)this.endNavPoint);
                this.state = State.COMMAND_ISSUED;
                return;
            }
            case COMMAND_ISSUED: {
                if (this.emohawkNavigation.isNavigating()) {
                    return;
                }
                if (this.info.isAtLocation((ILocated)this.endNavPoint, 150.0)) {
                    if (this.walkInCircles) {
                        this.emohawkNavigation.navigate((ILocated)this.startNavPoint);
                        this.state = State.RUNNING_BACK;
                        return;
                    }
                    --this.repetitions;
                    if (this.repetitions == 0) {
                        this.setSuccess("Successfully arrived to '" + this.endNavPointId.getStringId() + "'.");
                    } else {
                        this.log.info("Successfully arrived to '" + this.endNavPointId.getStringId() + "'.");
                        this.state = State.PREPARE_TEST;
                    }
                    return;
                }
                this.setFailure("Failed to arrive to '" + this.endNavPointId.getStringId() + "'.");
                return;
            }
            case RUNNING_BACK: {
                if (this.emohawkNavigation.isNavigating()) {
                    return;
                }
                if (this.info.isAtLocation((ILocated)this.startNavPoint, 150.0)) {
                    --this.repetitions;
                    if (this.repetitions == 0) {
                        this.setSuccess("Successfully arrived back to '" + this.startNavPointId.getStringId() + "'.");
                    } else {
                        this.log.info("Successfully arrived back to '" + this.startNavPointId.getStringId() + "'.");
                        this.state = State.SPAWNED;
                    }
                    return;
                }
                this.setFailure("Failed to arrive back at '" + this.startNavPointId.getStringId() + "'.");
                return;
            }
        }
    }

    public UnrealId getStartNavPointId() {
        return this.startNavPointId;
    }

    public void setStartNavPointId(String startNavPointId) {
        this.startNavPointId = UnrealId.get((String)startNavPointId);
    }

    public UnrealId getEndNavPointId() {
        return this.endNavPointId;
    }

    public void setEndNavPointId(String endNavpointId) {
        this.endNavPointId = UnrealId.get((String)endNavpointId);
    }

    public void setStartNavPointId(UnrealId startNavPointId) {
        this.startNavPointId = startNavPointId;
    }

    public void setEndNavPointId(UnrealId endNavpointId) {
        this.endNavPointId = endNavpointId;
    }

    public int getRepetitions() {
        return this.totalRepetitions == null ? 0 : this.totalRepetitions;
    }

    public void setRepetitions(int repetitions) {
        this.totalRepetitions = repetitions;
    }

    private static enum State {
        INIT,
        PREPARE_TEST,
        SPAWNED,
        COMMAND_ISSUED,
        RUNNING_BACK;

    }
}

